@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [Notification].
 */
@PulumiTagMarker
public class NotificationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NotificationArgs = NotificationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NotificationArgsBuilder.() -> Unit) {
        val builder = NotificationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Notification {
        val builtJavaResource = com.pulumi.aws.autoscaling.Notification(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Notification(builtJavaResource)
    }
}

/**
 * Provides an AutoScaling Group with Notification support, via SNS Topics. Each of
 * the `notifications` map to a [Notification Configuration](https://docs.aws.amazon.com/AutoScaling/latest/APIReference/API_DescribeNotificationConfigurations.html) inside Amazon Web
 * Services, and are applied to each AutoScaling Group you supply.
 * ## Example Usage
 * Basic usage:
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sns.Topic;
 * import com.pulumi.aws.autoscaling.Group;
 * import com.pulumi.aws.autoscaling.Notification;
 * import com.pulumi.aws.autoscaling.NotificationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Topic("example");
 *         var bar = new Group("bar");
 *         var foo = new Group("foo");
 *         var exampleNotifications = new Notification("exampleNotifications", NotificationArgs.builder()
 *             .groupNames(
 *                 bar.name(),
 *                 foo.name())
 *             .notifications(
 *                 "autoscaling:EC2_INSTANCE_LAUNCH",
 *                 "autoscaling:EC2_INSTANCE_TERMINATE",
 *                 "autoscaling:EC2_INSTANCE_LAUNCH_ERROR",
 *                 "autoscaling:EC2_INSTANCE_TERMINATE_ERROR")
 *             .topicArn(example.arn())
 *             .build());
 *     }
 * }
 * ```
 */
public class Notification internal constructor(
    override val javaResource: com.pulumi.aws.autoscaling.Notification,
) : KotlinCustomResource(javaResource, NotificationMapper) {
    /**
     * List of AutoScaling Group Names
     */
    public val groupNames: Output<List<String>>
        get() = javaResource.groupNames().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * List of Notification Types that trigger
     * notifications. Acceptable values are documented [in the AWS documentation here](https://docs.aws.amazon.com/AutoScaling/latest/APIReference/API_NotificationConfiguration.html)
     */
    public val notifications: Output<List<String>>
        get() = javaResource.notifications().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Topic ARN for notifications to be sent through
     */
    public val topicArn: Output<String>
        get() = javaResource.topicArn().applyValue({ args0 -> args0 })
}

public object NotificationMapper : ResourceMapper<Notification> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.autoscaling.Notification::class == javaResource::class

    override fun map(javaResource: Resource): Notification = Notification(
        javaResource as
            com.pulumi.aws.autoscaling.Notification,
    )
}

/**
 * @see [Notification].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Notification].
 */
public suspend fun notification(
    name: String,
    block: suspend NotificationResourceBuilder.() -> Unit,
): Notification {
    val builder = NotificationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Notification].
 * @param name The _unique_ name of the resulting resource.
 */
public fun notification(name: String): Notification {
    val builder = NotificationResourceBuilder()
    builder.name(name)
    return builder.build()
}
