@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin

import com.pulumi.aws.autoscaling.NotificationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides an AutoScaling Group with Notification support, via SNS Topics. Each of
 * the `notifications` map to a [Notification Configuration](https://docs.aws.amazon.com/AutoScaling/latest/APIReference/API_DescribeNotificationConfigurations.html) inside Amazon Web
 * Services, and are applied to each AutoScaling Group you supply.
 * ## Example Usage
 * Basic usage:
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sns.Topic;
 * import com.pulumi.aws.autoscaling.Group;
 * import com.pulumi.aws.autoscaling.Notification;
 * import com.pulumi.aws.autoscaling.NotificationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Topic("example");
 *         var bar = new Group("bar");
 *         var foo = new Group("foo");
 *         var exampleNotifications = new Notification("exampleNotifications", NotificationArgs.builder()
 *             .groupNames(
 *                 bar.name(),
 *                 foo.name())
 *             .notifications(
 *                 "autoscaling:EC2_INSTANCE_LAUNCH",
 *                 "autoscaling:EC2_INSTANCE_TERMINATE",
 *                 "autoscaling:EC2_INSTANCE_LAUNCH_ERROR",
 *                 "autoscaling:EC2_INSTANCE_TERMINATE_ERROR")
 *             .topicArn(example.arn())
 *             .build());
 *     }
 * }
 * ```
 * @property groupNames List of AutoScaling Group Names
 * @property notifications List of Notification Types that trigger
 * notifications. Acceptable values are documented [in the AWS documentation here](https://docs.aws.amazon.com/AutoScaling/latest/APIReference/API_NotificationConfiguration.html)
 * @property topicArn Topic ARN for notifications to be sent through
 */
public data class NotificationArgs(
    public val groupNames: Output<List<String>>? = null,
    public val notifications: Output<List<String>>? = null,
    public val topicArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.autoscaling.NotificationArgs> {
    override fun toJava(): com.pulumi.aws.autoscaling.NotificationArgs =
        com.pulumi.aws.autoscaling.NotificationArgs.builder()
            .groupNames(groupNames?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .notifications(notifications?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .topicArn(topicArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NotificationArgs].
 */
@PulumiTagMarker
public class NotificationArgsBuilder internal constructor() {
    private var groupNames: Output<List<String>>? = null

    private var notifications: Output<List<String>>? = null

    private var topicArn: Output<String>? = null

    /**
     * @param value List of AutoScaling Group Names
     */
    @JvmName("ktuukoqxtiqrhusv")
    public suspend fun groupNames(`value`: Output<List<String>>) {
        this.groupNames = value
    }

    @JvmName("fsairuqlganadcrr")
    public suspend fun groupNames(vararg values: Output<String>) {
        this.groupNames = Output.all(values.asList())
    }

    /**
     * @param values List of AutoScaling Group Names
     */
    @JvmName("iewaaavlnwvjuuds")
    public suspend fun groupNames(values: List<Output<String>>) {
        this.groupNames = Output.all(values)
    }

    /**
     * @param value List of Notification Types that trigger
     * notifications. Acceptable values are documented [in the AWS documentation here](https://docs.aws.amazon.com/AutoScaling/latest/APIReference/API_NotificationConfiguration.html)
     */
    @JvmName("lbkackdivjauhhvn")
    public suspend fun notifications(`value`: Output<List<String>>) {
        this.notifications = value
    }

    @JvmName("umhucpkjjwukayew")
    public suspend fun notifications(vararg values: Output<String>) {
        this.notifications = Output.all(values.asList())
    }

    /**
     * @param values List of Notification Types that trigger
     * notifications. Acceptable values are documented [in the AWS documentation here](https://docs.aws.amazon.com/AutoScaling/latest/APIReference/API_NotificationConfiguration.html)
     */
    @JvmName("utxqkyrxokffklgk")
    public suspend fun notifications(values: List<Output<String>>) {
        this.notifications = Output.all(values)
    }

    /**
     * @param value Topic ARN for notifications to be sent through
     */
    @JvmName("qdgbjdvwestyptsp")
    public suspend fun topicArn(`value`: Output<String>) {
        this.topicArn = value
    }

    /**
     * @param value List of AutoScaling Group Names
     */
    @JvmName("yebrgdpsnoaelupo")
    public suspend fun groupNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupNames = mapped
    }

    /**
     * @param values List of AutoScaling Group Names
     */
    @JvmName("wddpbdhuqmwlpfwm")
    public suspend fun groupNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupNames = mapped
    }

    /**
     * @param value List of Notification Types that trigger
     * notifications. Acceptable values are documented [in the AWS documentation here](https://docs.aws.amazon.com/AutoScaling/latest/APIReference/API_NotificationConfiguration.html)
     */
    @JvmName("oywidtrihiiqmudl")
    public suspend fun notifications(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notifications = mapped
    }

    /**
     * @param values List of Notification Types that trigger
     * notifications. Acceptable values are documented [in the AWS documentation here](https://docs.aws.amazon.com/AutoScaling/latest/APIReference/API_NotificationConfiguration.html)
     */
    @JvmName("ekkwsdyddmtoousj")
    public suspend fun notifications(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.notifications = mapped
    }

    /**
     * @param value Topic ARN for notifications to be sent through
     */
    @JvmName("vycrbgajuemufykc")
    public suspend fun topicArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.topicArn = mapped
    }

    internal fun build(): NotificationArgs = NotificationArgs(
        groupNames = groupNames,
        notifications = notifications,
        topicArn = topicArn,
    )
}
