@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin

import com.pulumi.aws.autoscaling.kotlin.outputs.PolicyPredictiveScalingConfiguration
import com.pulumi.aws.autoscaling.kotlin.outputs.PolicyStepAdjustment
import com.pulumi.aws.autoscaling.kotlin.outputs.PolicyTargetTrackingConfiguration
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.autoscaling.kotlin.outputs.PolicyPredictiveScalingConfiguration.Companion.toKotlin as policyPredictiveScalingConfigurationToKotlin
import com.pulumi.aws.autoscaling.kotlin.outputs.PolicyStepAdjustment.Companion.toKotlin as policyStepAdjustmentToKotlin
import com.pulumi.aws.autoscaling.kotlin.outputs.PolicyTargetTrackingConfiguration.Companion.toKotlin as policyTargetTrackingConfigurationToKotlin

/**
 * Builder for [Policy].
 */
@PulumiTagMarker
public class PolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PolicyArgs = PolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PolicyArgsBuilder.() -> Unit) {
        val builder = PolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Policy {
        val builtJavaResource = com.pulumi.aws.autoscaling.Policy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Policy(builtJavaResource)
    }
}

/**
 * Provides an AutoScaling Scaling Policy resource.
 * > **NOTE:** You may want to omit `desired_capacity` attribute from attached `aws.autoscaling.Group`
 * when using autoscaling policies. It's good practice to pick either
 * [manual](https://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/as-manual-scaling.html)
 * or [dynamic](https://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/as-scale-based-on-demand.html)
 * (policy-based) scaling.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.autoscaling.Group;
 * import com.pulumi.aws.autoscaling.GroupArgs;
 * import com.pulumi.aws.autoscaling.Policy;
 * import com.pulumi.aws.autoscaling.PolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var bar = new Group("bar", GroupArgs.builder()
 *             .availabilityZones("us-east-1a")
 *             .maxSize(5)
 *             .minSize(2)
 *             .healthCheckGracePeriod(300)
 *             .healthCheckType("ELB")
 *             .forceDelete(true)
 *             .launchConfiguration(aws_launch_configuration.foo().name())
 *             .build());
 *         var bat = new Policy("bat", PolicyArgs.builder()
 *             .scalingAdjustment(4)
 *             .adjustmentType("ChangeInCapacity")
 *             .cooldown(300)
 *             .autoscalingGroupName(bar.name())
 *             .build());
 *     }
 * }
 * ```
 * ### Create target tracking scaling policy using metric math
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.autoscaling.Policy;
 * import com.pulumi.aws.autoscaling.PolicyArgs;
 * import com.pulumi.aws.autoscaling.inputs.PolicyTargetTrackingConfigurationArgs;
 * import com.pulumi.aws.autoscaling.inputs.PolicyTargetTrackingConfigurationCustomizedMetricSpecificationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Policy("example", PolicyArgs.builder()
 *             .autoscalingGroupName("my-test-asg")
 *             .policyType("TargetTrackingScaling")
 *             .targetTrackingConfiguration(PolicyTargetTrackingConfigurationArgs.builder()
 *                 .customizedMetricSpecification(PolicyTargetTrackingConfigurationCustomizedMetricSpecificationArgs.builder()
 *                     .metrics(
 *                         PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricArgs.builder()
 *                             .id("m1")
 *                             .label("Get the queue size (the number of messages waiting to be processed)")
 *                             .metricStat(PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricMetricStatArgs.builder()
 *                                 .metric(PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricMetricStatMetricArgs.builder()
 *                                     .dimensions(PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricMetricStatMetricDimensionArgs.builder()
 *                                         .name("QueueName")
 *                                         .value("my-queue")
 *                                         .build())
 *                                     .metricName("ApproximateNumberOfMessagesVisible")
 *                                     .namespace("AWS/SQS")
 *                                     .build())
 *                                 .stat("Sum")
 *                                 .build())
 *                             .returnData(false)
 *                             .build(),
 *                         PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricArgs.builder()
 *                             .id("m2")
 *                             .label("Get the group size (the number of InService instances)")
 *                             .metricStat(PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricMetricStatArgs.builder()
 *                                 .metric(PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricMetricStatMetricArgs.builder()
 *                                     .dimensions(PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricMetricStatMetricDimensionArgs.builder()
 *                                         .name("AutoScalingGroupName")
 *                                         .value("my-asg")
 *                                         .build())
 *                                     .metricName("GroupInServiceInstances")
 *                                     .namespace("AWS/AutoScaling")
 *                                     .build())
 *                                 .stat("Average")
 *                                 .build())
 *                             .returnData(false)
 *                             .build(),
 *                         PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricArgs.builder()
 *                             .expression("m1 / m2")
 *                             .id("e1")
 *                             .label("Calculate the backlog per instance")
 *                             .returnData(true)
 *                             .build())
 *                     .build())
 *                 .targetValue(100)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create predictive scaling policy using customized metrics
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.autoscaling.Policy;
 * import com.pulumi.aws.autoscaling.PolicyArgs;
 * import com.pulumi.aws.autoscaling.inputs.PolicyPredictiveScalingConfigurationArgs;
 * import com.pulumi.aws.autoscaling.inputs.PolicyPredictiveScalingConfigurationMetricSpecificationArgs;
 * import com.pulumi.aws.autoscaling.inputs.PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedCapacityMetricSpecificationArgs;
 * import com.pulumi.aws.autoscaling.inputs.PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedLoadMetricSpecificationArgs;
 * import com.pulumi.aws.autoscaling.inputs.PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Policy("example", PolicyArgs.builder()
 *             .autoscalingGroupName("my-test-asg")
 *             .policyType("PredictiveScaling")
 *             .predictiveScalingConfiguration(PolicyPredictiveScalingConfigurationArgs.builder()
 *                 .metricSpecification(PolicyPredictiveScalingConfigurationMetricSpecificationArgs.builder()
 *                     .customizedCapacityMetricSpecification(PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedCapacityMetricSpecificationArgs.builder()
 *                         .metricDataQueries(PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedCapacityMetricSpecificationMetricDataQueryArgs.builder()
 *                             .expression("SUM(SEARCH('{AWS/AutoScaling,AutoScalingGroupName} MetricName=\"GroupInServiceIntances\" my-test-asg', 'Average', 300))")
 *                             .id("capacity_sum")
 *                             .build())
 *                         .build())
 *                     .customizedLoadMetricSpecification(PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedLoadMetricSpecificationArgs.builder()
 *                         .metricDataQueries(PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedLoadMetricSpecificationMetricDataQueryArgs.builder()
 *                             .expression("SUM(SEARCH('{AWS/EC2,AutoScalingGroupName} MetricName=\"CPUUtilization\" my-test-asg', 'Sum', 3600))")
 *                             .id("load_sum")
 *                             .build())
 *                         .build())
 *                     .customizedScalingMetricSpecification(PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationArgs.builder()
 *                         .metricDataQueries(
 *                             PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationMetricDataQueryArgs.builder()
 *                                 .expression("SUM(SEARCH('{AWS/AutoScaling,AutoScalingGroupName} MetricName=\"GroupInServiceIntances\" my-test-asg', 'Average', 300))")
 *                                 .id("capacity_sum")
 *                                 .returnData(false)
 *                                 .build(),
 *                             PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationMetricDataQueryArgs.builder()
 *                                 .expression("SUM(SEARCH('{AWS/EC2,AutoScalingGroupName} MetricName=\"CPUUtilization\" my-test-asg', 'Sum', 300))")
 *                                 .id("load_sum")
 *                                 .returnData(false)
 *                                 .build(),
 *                             PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationMetricDataQueryArgs.builder()
 *                                 .expression("load_sum / (capacity_sum * PERIOD(capacity_sum) / 60)")
 *                                 .id("weighted_average")
 *                                 .build())
 *                         .build())
 *                     .targetValue(10)
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create predictive scaling policy using customized scaling and predefined load metric
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.autoscaling.Policy;
 * import com.pulumi.aws.autoscaling.PolicyArgs;
 * import com.pulumi.aws.autoscaling.inputs.PolicyPredictiveScalingConfigurationArgs;
 * import com.pulumi.aws.autoscaling.inputs.PolicyPredictiveScalingConfigurationMetricSpecificationArgs;
 * import com.pulumi.aws.autoscaling.inputs.PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationArgs;
 * import com.pulumi.aws.autoscaling.inputs.PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedLoadMetricSpecificationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Policy("example", PolicyArgs.builder()
 *             .autoscalingGroupName("my-test-asg")
 *             .policyType("PredictiveScaling")
 *             .predictiveScalingConfiguration(PolicyPredictiveScalingConfigurationArgs.builder()
 *                 .metricSpecification(PolicyPredictiveScalingConfigurationMetricSpecificationArgs.builder()
 *                     .customizedScalingMetricSpecification(PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationArgs.builder()
 *                         .metricDataQueries(PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationMetricDataQueryArgs.builder()
 *                             .id("scaling")
 *                             .metricStat(PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationMetricDataQueryMetricStatArgs.builder()
 *                                 .metric(PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationMetricDataQueryMetricStatMetricArgs.builder()
 *                                     .dimensions(PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationMetricDataQueryMetricStatMetricDimensionArgs.builder()
 *                                         .name("AutoScalingGroupName")
 *                                         .value("my-test-asg")
 *                                         .build())
 *                                     .metricName("CPUUtilization")
 *                                     .namespace("AWS/EC2")
 *                                     .build())
 *                                 .stat("Average")
 *                                 .build())
 *                             .build())
 *                         .build())
 *                     .predefinedLoadMetricSpecification(PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedLoadMetricSpecificationArgs.builder()
 *                         .predefinedMetricType("ASGTotalCPUUtilization")
 *                         .resourceLabel("app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff")
 *                         .build())
 *                     .targetValue(10)
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import AutoScaling scaling policy using the role autoscaling_group_name and name separated by `/`. For example:
 * ```sh
 *  $ pulumi import aws:autoscaling/policy:Policy test-policy asg-name/policy-name
 * ```
 *
 */
public class Policy internal constructor(
    override val javaResource: com.pulumi.aws.autoscaling.Policy,
) : KotlinCustomResource(javaResource, PolicyMapper) {
    /**
     * Whether the adjustment is an absolute number or a percentage of the current capacity. Valid values are `ChangeInCapacity`, `ExactCapacity`, and `PercentChangeInCapacity`.
     */
    public val adjustmentType: Output<String>?
        get() = javaResource.adjustmentType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ARN assigned by AWS to the scaling policy.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Name of the autoscaling group.
     */
    public val autoscalingGroupName: Output<String>
        get() = javaResource.autoscalingGroupName().applyValue({ args0 -> args0 })

    /**
     * Amount of time, in seconds, after a scaling activity completes and before the next scaling activity can start.
     */
    public val cooldown: Output<Int>?
        get() = javaResource.cooldown().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Whether the scaling policy is enabled or disabled. Default: `true`.
     * The following argument is only available to "SimpleScaling" and "StepScaling" type policies:
     */
    public val enabled: Output<Boolean>?
        get() = javaResource.enabled().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Estimated time, in seconds, until a newly launched instance will contribute CloudWatch metrics. Without a value, AWS will default to the group's specified cooldown period.
     */
    public val estimatedInstanceWarmup: Output<Int>?
        get() = javaResource.estimatedInstanceWarmup().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Aggregation type for the policy's metrics. Valid values are "Minimum", "Maximum", and "Average". Without a value, AWS will treat the aggregation type as "Average".
     */
    public val metricAggregationType: Output<String>
        get() = javaResource.metricAggregationType().applyValue({ args0 -> args0 })

    /**
     * Minimum value to scale by when `adjustment_type` is set to `PercentChangeInCapacity`.
     * The following arguments are only available to "SimpleScaling" type policies:
     */
    public val minAdjustmentMagnitude: Output<Int>?
        get() = javaResource.minAdjustmentMagnitude().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the policy.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Policy type, either "SimpleScaling", "StepScaling", "TargetTrackingScaling", or "PredictiveScaling". If this value isn't provided, AWS will default to "SimpleScaling."
     */
    public val policyType: Output<String>?
        get() = javaResource.policyType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Predictive scaling policy configuration to use with Amazon EC2 Auto Scaling.
     */
    public val predictiveScalingConfiguration: Output<PolicyPredictiveScalingConfiguration>?
        get() = javaResource.predictiveScalingConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> policyPredictiveScalingConfigurationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Number of members by which to
     * scale, when the adjustment bounds are breached. A positive value scales
     * up. A negative value scales down.
     */
    public val scalingAdjustment: Output<Int>?
        get() = javaResource.scalingAdjustment().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Set of adjustments that manage
     * group scaling. These have the following structure:
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = new aws.autoscaling.Policy("example", {stepAdjustments: [
     *     {
     *         metricIntervalLowerBound: "1",
     *         metricIntervalUpperBound: "2",
     *         scalingAdjustment: -1,
     *     },
     *     {
     *         metricIntervalLowerBound: "2",
     *         metricIntervalUpperBound: "3",
     *         scalingAdjustment: 1,
     *     },
     * ]});
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.autoscaling.Policy("example", step_adjustments=[
     *     aws.autoscaling.PolicyStepAdjustmentArgs(
     *         metric_interval_lower_bound="1",
     *         metric_interval_upper_bound="2",
     *         scaling_adjustment=-1,
     *     ),
     *     aws.autoscaling.PolicyStepAdjustmentArgs(
     *         metric_interval_lower_bound="2",
     *         metric_interval_upper_bound="3",
     *         scaling_adjustment=1,
     *     ),
     * ])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = new Aws.AutoScaling.Policy("example", new()
     *     {
     *         StepAdjustments = new[]
     *         {
     *             new Aws.AutoScaling.Inputs.PolicyStepAdjustmentArgs
     *             {
     *                 MetricIntervalLowerBound = "1",
     *                 MetricIntervalUpperBound = "2",
     *                 ScalingAdjustment = -1,
     *             },
     *             new Aws.AutoScaling.Inputs.PolicyStepAdjustmentArgs
     *             {
     *                 MetricIntervalLowerBound = "2",
     *                 MetricIntervalUpperBound = "3",
     *                 ScalingAdjustment = 1,
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/autoscaling"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := autoscaling.NewPolicy(ctx, "example", &autoscaling.PolicyArgs{
     * 			StepAdjustments: autoscaling.PolicyStepAdjustmentArray{
     * 				&autoscaling.PolicyStepAdjustmentArgs{
     * 					MetricIntervalLowerBound: pulumi.String("1"),
     * 					MetricIntervalUpperBound: pulumi.String("2"),
     * 					ScalingAdjustment:        -1,
     * 				},
     * 				&autoscaling.PolicyStepAdjustmentArgs{
     * 					MetricIntervalLowerBound: pulumi.String("2"),
     * 					MetricIntervalUpperBound: pulumi.String("3"),
     * 					ScalingAdjustment:        pulumi.Int(1),
     * 				},
     * 			},
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * The following fields are available in step adjustments:
     */
    public val stepAdjustments: Output<List<PolicyStepAdjustment>>?
        get() = javaResource.stepAdjustments().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        policyStepAdjustmentToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Target tracking policy. These have the following structure:
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = new aws.autoscaling.Policy("example", {targetTrackingConfiguration: {
     *     predefinedMetricSpecification: {
     *         predefinedMetricType: "ASGAverageCPUUtilization",
     *     },
     *     targetValue: 40,
     * }});
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.autoscaling.Policy("example", target_tracking_configuration=aws.autoscaling.PolicyTargetTrackingConfigurationArgs(
     *     predefined_metric_specification=aws.autoscaling.PolicyTargetTrackingConfigurationPredefinedMetricSpecificationArgs(
     *         predefined_metric_type="ASGAverageCPUUtilization",
     *     ),
     *     target_value=40,
     * ))
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = new Aws.AutoScaling.Policy("example", new()
     *     {
     *         TargetTrackingConfiguration = new Aws.AutoScaling.Inputs.PolicyTargetTrackingConfigurationArgs
     *         {
     *             PredefinedMetricSpecification = new Aws.AutoScaling.Inputs.PolicyTargetTrackingConfigurationPredefinedMetricSpecificationArgs
     *             {
     *                 PredefinedMetricType = "ASGAverageCPUUtilization",
     *             },
     *             TargetValue = 40,
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/autoscaling"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := autoscaling.NewPolicy(ctx, "example", &autoscaling.PolicyArgs{
     * 			TargetTrackingConfiguration: &autoscaling.PolicyTargetTrackingConfigurationArgs{
     * 				PredefinedMetricSpecification: &autoscaling.PolicyTargetTrackingConfigurationPredefinedMetricSpecificationArgs{
     * 					PredefinedMetricType: pulumi.String("ASGAverageCPUUtilization"),
     * 				},
     * 				TargetValue: pulumi.Float64(40),
     * 			},
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.autoscaling.Policy;
     * import com.pulumi.aws.autoscaling.PolicyArgs;
     * import com.pulumi.aws.autoscaling.inputs.PolicyTargetTrackingConfigurationArgs;
     * import com.pulumi.aws.autoscaling.inputs.PolicyTargetTrackingConfigurationPredefinedMetricSpecificationArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         var example = new Policy("example", PolicyArgs.builder()
     *             .targetTrackingConfiguration(PolicyTargetTrackingConfigurationArgs.builder()
     *                 .predefinedMetricSpecification(PolicyTargetTrackingConfigurationPredefinedMetricSpecificationArgs.builder()
     *                     .predefinedMetricType("ASGAverageCPUUtilization")
     *                     .build())
     *                 .targetValue(40)
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   example:
     *     type: aws:autoscaling:Policy
     *     properties:
     *       targetTrackingConfiguration:
     *         predefinedMetricSpecification:
     *           predefinedMetricType: ASGAverageCPUUtilization
     *         targetValue: 40
     * ```
     * The following fields are available in target tracking configuration:
     */
    public val targetTrackingConfiguration: Output<PolicyTargetTrackingConfiguration>?
        get() = javaResource.targetTrackingConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> policyTargetTrackingConfigurationToKotlin(args0) })
            }).orElse(null)
        })
}

public object PolicyMapper : ResourceMapper<Policy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.autoscaling.Policy::class == javaResource::class

    override fun map(javaResource: Resource): Policy = Policy(
        javaResource as
            com.pulumi.aws.autoscaling.Policy,
    )
}

/**
 * @see [Policy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Policy].
 */
public suspend fun policy(name: String, block: suspend PolicyResourceBuilder.() -> Unit): Policy {
    val builder = PolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Policy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun policy(name: String): Policy {
    val builder = PolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
