@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin

import com.pulumi.aws.autoscaling.TagArgs.builder
import com.pulumi.aws.autoscaling.kotlin.inputs.TagTagArgs
import com.pulumi.aws.autoscaling.kotlin.inputs.TagTagArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Manages an individual Autoscaling Group (ASG) tag. This resource should only be used in cases where ASGs are created outside the provider (e.g., ASGs implicitly created by EKS Node Groups).
 * > **NOTE:** This tagging resource should not be combined with the resource for managing the parent resource. For example, using `aws.autoscaling.Group` and `aws.autoscaling.Tag` to manage tags of the same ASG will cause a perpetual difference where the `aws.autoscaling.Group` resource will try to remove the tag being added by the `aws.autoscaling.Tag` resource.
 * > **NOTE:** This tagging resource does not use the provider `ignore_tags` configuration.
 * ## Import
 * Using `pulumi import`, import `aws_autoscaling_group_tag` using the ASG name and key, separated by a comma (`,`). For example:
 * ```sh
 *  $ pulumi import aws:autoscaling/tag:Tag example asg-example,k8s.io/cluster-autoscaler/node-template/label/eks.amazonaws.com/capacityType
 * ```
 * @property autoscalingGroupName Name of the Autoscaling Group to apply the tag to.
 * @property tag Tag to create. The `tag` block is documented below.
 */
public data class TagArgs(
    public val autoscalingGroupName: Output<String>? = null,
    public val tag: Output<TagTagArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.autoscaling.TagArgs> {
    override fun toJava(): com.pulumi.aws.autoscaling.TagArgs =
        com.pulumi.aws.autoscaling.TagArgs.builder()
            .autoscalingGroupName(autoscalingGroupName?.applyValue({ args0 -> args0 }))
            .tag(tag?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [TagArgs].
 */
@PulumiTagMarker
public class TagArgsBuilder internal constructor() {
    private var autoscalingGroupName: Output<String>? = null

    private var tag: Output<TagTagArgs>? = null

    /**
     * @param value Name of the Autoscaling Group to apply the tag to.
     */
    @JvmName("taakqjuctcvdndkm")
    public suspend fun autoscalingGroupName(`value`: Output<String>) {
        this.autoscalingGroupName = value
    }

    /**
     * @param value Tag to create. The `tag` block is documented below.
     */
    @JvmName("tummfkcvokwrlovl")
    public suspend fun tag(`value`: Output<TagTagArgs>) {
        this.tag = value
    }

    /**
     * @param value Name of the Autoscaling Group to apply the tag to.
     */
    @JvmName("mnupxfojsfpguwxd")
    public suspend fun autoscalingGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoscalingGroupName = mapped
    }

    /**
     * @param value Tag to create. The `tag` block is documented below.
     */
    @JvmName("lxljdgqwbkoffpdt")
    public suspend fun tag(`value`: TagTagArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tag = mapped
    }

    /**
     * @param argument Tag to create. The `tag` block is documented below.
     */
    @JvmName("acyjqdlercnsmrsr")
    public suspend fun tag(argument: suspend TagTagArgsBuilder.() -> Unit) {
        val toBeMapped = TagTagArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tag = mapped
    }

    internal fun build(): TagArgs = TagArgs(
        autoscalingGroupName = autoscalingGroupName,
        tag = tag,
    )
}
