@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin

import com.pulumi.aws.autoscaling.kotlin.outputs.TrafficSourceAttachmentTrafficSource
import com.pulumi.aws.autoscaling.kotlin.outputs.TrafficSourceAttachmentTrafficSource.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [TrafficSourceAttachment].
 */
@PulumiTagMarker
public class TrafficSourceAttachmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TrafficSourceAttachmentArgs = TrafficSourceAttachmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TrafficSourceAttachmentArgsBuilder.() -> Unit) {
        val builder = TrafficSourceAttachmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): TrafficSourceAttachment {
        val builtJavaResource =
            com.pulumi.aws.autoscaling.TrafficSourceAttachment(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return TrafficSourceAttachment(builtJavaResource)
    }
}

/**
 * Attaches a traffic source to an Auto Scaling group.
 * > **NOTE on Auto Scaling Groups, Attachments and Traffic Source Attachments:** Pulumi provides standalone Attachment (for attaching Classic Load Balancers and Application Load Balancer, Gateway Load Balancer, or Network Load Balancer target groups) and Traffic Source Attachment (for attaching Load Balancers and VPC Lattice target groups) resources and an Auto Scaling Group resource with `load_balancers`, `target_group_arns` and `traffic_source` attributes. Do not use the same traffic source in more than one of these resources. Doing so will cause a conflict of attachments. A `lifecycle` configuration block can be used to suppress differences if necessary.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.autoscaling.TrafficSourceAttachment;
 * import com.pulumi.aws.autoscaling.TrafficSourceAttachmentArgs;
 * import com.pulumi.aws.autoscaling.inputs.TrafficSourceAttachmentTrafficSourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new TrafficSourceAttachment("example", TrafficSourceAttachmentArgs.builder()
 *             .autoscalingGroupName(aws_autoscaling_group.example().id())
 *             .trafficSource(TrafficSourceAttachmentTrafficSourceArgs.builder()
 *                 .identifier(aws_lb_target_group.example().arn())
 *                 .type("elbv2")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 */
public class TrafficSourceAttachment internal constructor(
    override val javaResource: com.pulumi.aws.autoscaling.TrafficSourceAttachment,
) : KotlinCustomResource(javaResource, TrafficSourceAttachmentMapper) {
    /**
     * The name of the Auto Scaling group.
     */
    public val autoscalingGroupName: Output<String>
        get() = javaResource.autoscalingGroupName().applyValue({ args0 -> args0 })

    /**
     * The unique identifiers of a traffic sources.
     */
    public val trafficSource: Output<TrafficSourceAttachmentTrafficSource>?
        get() = javaResource.trafficSource().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })
}

public object TrafficSourceAttachmentMapper : ResourceMapper<TrafficSourceAttachment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.autoscaling.TrafficSourceAttachment::class == javaResource::class

    override fun map(javaResource: Resource): TrafficSourceAttachment =
        TrafficSourceAttachment(javaResource as com.pulumi.aws.autoscaling.TrafficSourceAttachment)
}

/**
 * @see [TrafficSourceAttachment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TrafficSourceAttachment].
 */
public suspend fun trafficSourceAttachment(
    name: String,
    block: suspend TrafficSourceAttachmentResourceBuilder.() -> Unit,
): TrafficSourceAttachment {
    val builder = TrafficSourceAttachmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TrafficSourceAttachment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun trafficSourceAttachment(name: String): TrafficSourceAttachment {
    val builder = TrafficSourceAttachmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
