@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin

import com.pulumi.aws.autoscaling.TrafficSourceAttachmentArgs.builder
import com.pulumi.aws.autoscaling.kotlin.inputs.TrafficSourceAttachmentTrafficSourceArgs
import com.pulumi.aws.autoscaling.kotlin.inputs.TrafficSourceAttachmentTrafficSourceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Attaches a traffic source to an Auto Scaling group.
 * > **NOTE on Auto Scaling Groups, Attachments and Traffic Source Attachments:** Pulumi provides standalone Attachment (for attaching Classic Load Balancers and Application Load Balancer, Gateway Load Balancer, or Network Load Balancer target groups) and Traffic Source Attachment (for attaching Load Balancers and VPC Lattice target groups) resources and an Auto Scaling Group resource with `load_balancers`, `target_group_arns` and `traffic_source` attributes. Do not use the same traffic source in more than one of these resources. Doing so will cause a conflict of attachments. A `lifecycle` configuration block can be used to suppress differences if necessary.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.autoscaling.TrafficSourceAttachment;
 * import com.pulumi.aws.autoscaling.TrafficSourceAttachmentArgs;
 * import com.pulumi.aws.autoscaling.inputs.TrafficSourceAttachmentTrafficSourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new TrafficSourceAttachment("example", TrafficSourceAttachmentArgs.builder()
 *             .autoscalingGroupName(aws_autoscaling_group.example().id())
 *             .trafficSource(TrafficSourceAttachmentTrafficSourceArgs.builder()
 *                 .identifier(aws_lb_target_group.example().arn())
 *                 .type("elbv2")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * @property autoscalingGroupName The name of the Auto Scaling group.
 * @property trafficSource The unique identifiers of a traffic sources.
 */
public data class TrafficSourceAttachmentArgs(
    public val autoscalingGroupName: Output<String>? = null,
    public val trafficSource: Output<TrafficSourceAttachmentTrafficSourceArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.autoscaling.TrafficSourceAttachmentArgs> {
    override fun toJava(): com.pulumi.aws.autoscaling.TrafficSourceAttachmentArgs =
        com.pulumi.aws.autoscaling.TrafficSourceAttachmentArgs.builder()
            .autoscalingGroupName(autoscalingGroupName?.applyValue({ args0 -> args0 }))
            .trafficSource(trafficSource?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [TrafficSourceAttachmentArgs].
 */
@PulumiTagMarker
public class TrafficSourceAttachmentArgsBuilder internal constructor() {
    private var autoscalingGroupName: Output<String>? = null

    private var trafficSource: Output<TrafficSourceAttachmentTrafficSourceArgs>? = null

    /**
     * @param value The name of the Auto Scaling group.
     */
    @JvmName("crtobdwargsbghwa")
    public suspend fun autoscalingGroupName(`value`: Output<String>) {
        this.autoscalingGroupName = value
    }

    /**
     * @param value The unique identifiers of a traffic sources.
     */
    @JvmName("yluuivrrgdkjybih")
    public suspend fun trafficSource(`value`: Output<TrafficSourceAttachmentTrafficSourceArgs>) {
        this.trafficSource = value
    }

    /**
     * @param value The name of the Auto Scaling group.
     */
    @JvmName("mxyfcgvjhktleicx")
    public suspend fun autoscalingGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoscalingGroupName = mapped
    }

    /**
     * @param value The unique identifiers of a traffic sources.
     */
    @JvmName("ehslftijrpbwkcor")
    public suspend fun trafficSource(`value`: TrafficSourceAttachmentTrafficSourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trafficSource = mapped
    }

    /**
     * @param argument The unique identifiers of a traffic sources.
     */
    @JvmName("lxsjxqiaiipvjcsn")
    public suspend
    fun trafficSource(argument: suspend TrafficSourceAttachmentTrafficSourceArgsBuilder.() -> Unit) {
        val toBeMapped = TrafficSourceAttachmentTrafficSourceArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.trafficSource = mapped
    }

    internal fun build(): TrafficSourceAttachmentArgs = TrafficSourceAttachmentArgs(
        autoscalingGroupName = autoscalingGroupName,
        trafficSource = trafficSource,
    )
}
