@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin.inputs

import com.pulumi.aws.autoscaling.inputs.GetGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getGroup.
 * @property name Specify the exact name of the desired autoscaling group.
 */
public data class GetGroupPlainArgs(
    public val name: String,
) : ConvertibleToJava<com.pulumi.aws.autoscaling.inputs.GetGroupPlainArgs> {
    override fun toJava(): com.pulumi.aws.autoscaling.inputs.GetGroupPlainArgs =
        com.pulumi.aws.autoscaling.inputs.GetGroupPlainArgs.builder()
            .name(name.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGroupPlainArgs].
 */
@PulumiTagMarker
public class GetGroupPlainArgsBuilder internal constructor() {
    private var name: String? = null

    /**
     * @param value Specify the exact name of the desired autoscaling group.
     */
    @JvmName("sacmmferxtetituh")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    internal fun build(): GetGroupPlainArgs = GetGroupPlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
