@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin.inputs

import com.pulumi.aws.autoscaling.inputs.GroupInitialLifecycleHookArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property defaultResult
 * @property heartbeatTimeout
 * @property lifecycleTransition
 * @property name Name of the Auto Scaling Group. By default generated by Pulumi. Conflicts with `name_prefix`.
 * @property notificationMetadata
 * @property notificationTargetArn
 * @property roleArn
 */
public data class GroupInitialLifecycleHookArgs(
    public val defaultResult: Output<String>? = null,
    public val heartbeatTimeout: Output<Int>? = null,
    public val lifecycleTransition: Output<String>,
    public val name: Output<String>,
    public val notificationMetadata: Output<String>? = null,
    public val notificationTargetArn: Output<String>? = null,
    public val roleArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.autoscaling.inputs.GroupInitialLifecycleHookArgs> {
    override fun toJava(): com.pulumi.aws.autoscaling.inputs.GroupInitialLifecycleHookArgs =
        com.pulumi.aws.autoscaling.inputs.GroupInitialLifecycleHookArgs.builder()
            .defaultResult(defaultResult?.applyValue({ args0 -> args0 }))
            .heartbeatTimeout(heartbeatTimeout?.applyValue({ args0 -> args0 }))
            .lifecycleTransition(lifecycleTransition.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .notificationMetadata(notificationMetadata?.applyValue({ args0 -> args0 }))
            .notificationTargetArn(notificationTargetArn?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GroupInitialLifecycleHookArgs].
 */
@PulumiTagMarker
public class GroupInitialLifecycleHookArgsBuilder internal constructor() {
    private var defaultResult: Output<String>? = null

    private var heartbeatTimeout: Output<Int>? = null

    private var lifecycleTransition: Output<String>? = null

    private var name: Output<String>? = null

    private var notificationMetadata: Output<String>? = null

    private var notificationTargetArn: Output<String>? = null

    private var roleArn: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("nqiqmajdcvmtfyje")
    public suspend fun defaultResult(`value`: Output<String>) {
        this.defaultResult = value
    }

    /**
     * @param value
     */
    @JvmName("mcpocxjxwbvtgolh")
    public suspend fun heartbeatTimeout(`value`: Output<Int>) {
        this.heartbeatTimeout = value
    }

    /**
     * @param value
     */
    @JvmName("dhrmkrxyjwulovvr")
    public suspend fun lifecycleTransition(`value`: Output<String>) {
        this.lifecycleTransition = value
    }

    /**
     * @param value Name of the Auto Scaling Group. By default generated by Pulumi. Conflicts with `name_prefix`.
     */
    @JvmName("dstfoyqvwrvxpgjg")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value
     */
    @JvmName("qpbjouyndgfuergy")
    public suspend fun notificationMetadata(`value`: Output<String>) {
        this.notificationMetadata = value
    }

    /**
     * @param value
     */
    @JvmName("jrydvmninpecanxu")
    public suspend fun notificationTargetArn(`value`: Output<String>) {
        this.notificationTargetArn = value
    }

    /**
     * @param value
     */
    @JvmName("xtdyywxrpylngkck")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value
     */
    @JvmName("edtuqknbdvtfvwyl")
    public suspend fun defaultResult(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultResult = mapped
    }

    /**
     * @param value
     */
    @JvmName("axvyfvvoqeaprams")
    public suspend fun heartbeatTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.heartbeatTimeout = mapped
    }

    /**
     * @param value
     */
    @JvmName("rnslospjrnsopggd")
    public suspend fun lifecycleTransition(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lifecycleTransition = mapped
    }

    /**
     * @param value Name of the Auto Scaling Group. By default generated by Pulumi. Conflicts with `name_prefix`.
     */
    @JvmName("epoxsjjwoxmtxpyb")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("rntrfxihwybshijs")
    public suspend fun notificationMetadata(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notificationMetadata = mapped
    }

    /**
     * @param value
     */
    @JvmName("ixsooecrllaxchel")
    public suspend fun notificationTargetArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notificationTargetArn = mapped
    }

    /**
     * @param value
     */
    @JvmName("csngbqudjdifjtfc")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    internal fun build(): GroupInitialLifecycleHookArgs = GroupInitialLifecycleHookArgs(
        defaultResult = defaultResult,
        heartbeatTimeout = heartbeatTimeout,
        lifecycleTransition = lifecycleTransition ?: throw PulumiNullFieldException("lifecycleTransition"),
        name = name ?: throw PulumiNullFieldException("name"),
        notificationMetadata = notificationMetadata,
        notificationTargetArn = notificationTargetArn,
        roleArn = roleArn,
    )
}
