@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin.inputs

import com.pulumi.aws.autoscaling.inputs.GroupInstanceMaintenancePolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property maxHealthyPercentage Specifies the upper limit on the number of instances that are in the InService or Pending state with a healthy status during an instance replacement activity.
 * @property minHealthyPercentage Specifies the lower limit on the number of instances that must be in the InService state with a healthy status during an instance replacement activity.
 */
public data class GroupInstanceMaintenancePolicyArgs(
    public val maxHealthyPercentage: Output<Int>,
    public val minHealthyPercentage: Output<Int>,
) : ConvertibleToJava<com.pulumi.aws.autoscaling.inputs.GroupInstanceMaintenancePolicyArgs> {
    override fun toJava(): com.pulumi.aws.autoscaling.inputs.GroupInstanceMaintenancePolicyArgs =
        com.pulumi.aws.autoscaling.inputs.GroupInstanceMaintenancePolicyArgs.builder()
            .maxHealthyPercentage(maxHealthyPercentage.applyValue({ args0 -> args0 }))
            .minHealthyPercentage(minHealthyPercentage.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GroupInstanceMaintenancePolicyArgs].
 */
@PulumiTagMarker
public class GroupInstanceMaintenancePolicyArgsBuilder internal constructor() {
    private var maxHealthyPercentage: Output<Int>? = null

    private var minHealthyPercentage: Output<Int>? = null

    /**
     * @param value Specifies the upper limit on the number of instances that are in the InService or Pending state with a healthy status during an instance replacement activity.
     */
    @JvmName("yplitqpxvadtxycp")
    public suspend fun maxHealthyPercentage(`value`: Output<Int>) {
        this.maxHealthyPercentage = value
    }

    /**
     * @param value Specifies the lower limit on the number of instances that must be in the InService state with a healthy status during an instance replacement activity.
     */
    @JvmName("rsaynssvhwywsmbq")
    public suspend fun minHealthyPercentage(`value`: Output<Int>) {
        this.minHealthyPercentage = value
    }

    /**
     * @param value Specifies the upper limit on the number of instances that are in the InService or Pending state with a healthy status during an instance replacement activity.
     */
    @JvmName("dejibvndgsnrgxtg")
    public suspend fun maxHealthyPercentage(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maxHealthyPercentage = mapped
    }

    /**
     * @param value Specifies the lower limit on the number of instances that must be in the InService state with a healthy status during an instance replacement activity.
     */
    @JvmName("pnvolhoadidyggeo")
    public suspend fun minHealthyPercentage(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.minHealthyPercentage = mapped
    }

    internal fun build(): GroupInstanceMaintenancePolicyArgs = GroupInstanceMaintenancePolicyArgs(
        maxHealthyPercentage = maxHealthyPercentage ?: throw
            PulumiNullFieldException("maxHealthyPercentage"),
        minHealthyPercentage = minHealthyPercentage ?: throw
            PulumiNullFieldException("minHealthyPercentage"),
    )
}
