@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin.inputs

import com.pulumi.aws.autoscaling.inputs.GroupInstanceRefreshArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property preferences Override default parameters for Instance Refresh.
 * @property strategy Strategy to use for instance refresh. The only allowed value is `Rolling`. See [StartInstanceRefresh Action](https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_StartInstanceRefresh.html#API_StartInstanceRefresh_RequestParameters) for more information.
 * @property triggers Set of additional property names that will trigger an Instance Refresh. A refresh will always be triggered by a change in any of `launch_configuration`, `launch_template`, or `mixed_instances_policy`.
 * > **NOTE:** A refresh is started when any of the following Auto Scaling Group properties change: `launch_configuration`, `launch_template`, `mixed_instances_policy`. Additional properties can be specified in the `triggers` property of `instance_refresh`.
 * > **NOTE:** A refresh will not start when `version = "$Latest"` is configured in the `launch_template` block. To trigger the instance refresh when a launch template is changed, configure `version` to use the `latest_version` attribute of the `aws.ec2.LaunchTemplate` resource.
 * > **NOTE:** Auto Scaling Groups support up to one active instance refresh at a time. When this resource is updated, any existing refresh is cancelled.
 * > **NOTE:** Depending on health check settings and group size, an instance refresh may take a long time or fail. This resource does not wait for the instance refresh to complete.
 */
public data class GroupInstanceRefreshArgs(
    public val preferences: Output<GroupInstanceRefreshPreferencesArgs>? = null,
    public val strategy: Output<String>,
    public val triggers: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.autoscaling.inputs.GroupInstanceRefreshArgs> {
    override fun toJava(): com.pulumi.aws.autoscaling.inputs.GroupInstanceRefreshArgs =
        com.pulumi.aws.autoscaling.inputs.GroupInstanceRefreshArgs.builder()
            .preferences(preferences?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .strategy(strategy.applyValue({ args0 -> args0 }))
            .triggers(triggers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [GroupInstanceRefreshArgs].
 */
@PulumiTagMarker
public class GroupInstanceRefreshArgsBuilder internal constructor() {
    private var preferences: Output<GroupInstanceRefreshPreferencesArgs>? = null

    private var strategy: Output<String>? = null

    private var triggers: Output<List<String>>? = null

    /**
     * @param value Override default parameters for Instance Refresh.
     */
    @JvmName("llfxvsnllhlxhbax")
    public suspend fun preferences(`value`: Output<GroupInstanceRefreshPreferencesArgs>) {
        this.preferences = value
    }

    /**
     * @param value Strategy to use for instance refresh. The only allowed value is `Rolling`. See [StartInstanceRefresh Action](https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_StartInstanceRefresh.html#API_StartInstanceRefresh_RequestParameters) for more information.
     */
    @JvmName("qgsmoyafamphrmmg")
    public suspend fun strategy(`value`: Output<String>) {
        this.strategy = value
    }

    /**
     * @param value Set of additional property names that will trigger an Instance Refresh. A refresh will always be triggered by a change in any of `launch_configuration`, `launch_template`, or `mixed_instances_policy`.
     * > **NOTE:** A refresh is started when any of the following Auto Scaling Group properties change: `launch_configuration`, `launch_template`, `mixed_instances_policy`. Additional properties can be specified in the `triggers` property of `instance_refresh`.
     * > **NOTE:** A refresh will not start when `version = "$Latest"` is configured in the `launch_template` block. To trigger the instance refresh when a launch template is changed, configure `version` to use the `latest_version` attribute of the `aws.ec2.LaunchTemplate` resource.
     * > **NOTE:** Auto Scaling Groups support up to one active instance refresh at a time. When this resource is updated, any existing refresh is cancelled.
     * > **NOTE:** Depending on health check settings and group size, an instance refresh may take a long time or fail. This resource does not wait for the instance refresh to complete.
     */
    @JvmName("kruhkkbvlmjplpgf")
    public suspend fun triggers(`value`: Output<List<String>>) {
        this.triggers = value
    }

    @JvmName("mtiyhtuxnetkwrop")
    public suspend fun triggers(vararg values: Output<String>) {
        this.triggers = Output.all(values.asList())
    }

    /**
     * @param values Set of additional property names that will trigger an Instance Refresh. A refresh will always be triggered by a change in any of `launch_configuration`, `launch_template`, or `mixed_instances_policy`.
     * > **NOTE:** A refresh is started when any of the following Auto Scaling Group properties change: `launch_configuration`, `launch_template`, `mixed_instances_policy`. Additional properties can be specified in the `triggers` property of `instance_refresh`.
     * > **NOTE:** A refresh will not start when `version = "$Latest"` is configured in the `launch_template` block. To trigger the instance refresh when a launch template is changed, configure `version` to use the `latest_version` attribute of the `aws.ec2.LaunchTemplate` resource.
     * > **NOTE:** Auto Scaling Groups support up to one active instance refresh at a time. When this resource is updated, any existing refresh is cancelled.
     * > **NOTE:** Depending on health check settings and group size, an instance refresh may take a long time or fail. This resource does not wait for the instance refresh to complete.
     */
    @JvmName("gbpbryknvklkcrqq")
    public suspend fun triggers(values: List<Output<String>>) {
        this.triggers = Output.all(values)
    }

    /**
     * @param value Override default parameters for Instance Refresh.
     */
    @JvmName("obdkuovtrdqoswdn")
    public suspend fun preferences(`value`: GroupInstanceRefreshPreferencesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preferences = mapped
    }

    /**
     * @param argument Override default parameters for Instance Refresh.
     */
    @JvmName("xnyvqadxqihvivol")
    public suspend
    fun preferences(argument: suspend GroupInstanceRefreshPreferencesArgsBuilder.() -> Unit) {
        val toBeMapped = GroupInstanceRefreshPreferencesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.preferences = mapped
    }

    /**
     * @param value Strategy to use for instance refresh. The only allowed value is `Rolling`. See [StartInstanceRefresh Action](https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_StartInstanceRefresh.html#API_StartInstanceRefresh_RequestParameters) for more information.
     */
    @JvmName("avfubkftafclxasp")
    public suspend fun strategy(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.strategy = mapped
    }

    /**
     * @param value Set of additional property names that will trigger an Instance Refresh. A refresh will always be triggered by a change in any of `launch_configuration`, `launch_template`, or `mixed_instances_policy`.
     * > **NOTE:** A refresh is started when any of the following Auto Scaling Group properties change: `launch_configuration`, `launch_template`, `mixed_instances_policy`. Additional properties can be specified in the `triggers` property of `instance_refresh`.
     * > **NOTE:** A refresh will not start when `version = "$Latest"` is configured in the `launch_template` block. To trigger the instance refresh when a launch template is changed, configure `version` to use the `latest_version` attribute of the `aws.ec2.LaunchTemplate` resource.
     * > **NOTE:** Auto Scaling Groups support up to one active instance refresh at a time. When this resource is updated, any existing refresh is cancelled.
     * > **NOTE:** Depending on health check settings and group size, an instance refresh may take a long time or fail. This resource does not wait for the instance refresh to complete.
     */
    @JvmName("lblhvopbvjjvsysn")
    public suspend fun triggers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.triggers = mapped
    }

    /**
     * @param values Set of additional property names that will trigger an Instance Refresh. A refresh will always be triggered by a change in any of `launch_configuration`, `launch_template`, or `mixed_instances_policy`.
     * > **NOTE:** A refresh is started when any of the following Auto Scaling Group properties change: `launch_configuration`, `launch_template`, `mixed_instances_policy`. Additional properties can be specified in the `triggers` property of `instance_refresh`.
     * > **NOTE:** A refresh will not start when `version = "$Latest"` is configured in the `launch_template` block. To trigger the instance refresh when a launch template is changed, configure `version` to use the `latest_version` attribute of the `aws.ec2.LaunchTemplate` resource.
     * > **NOTE:** Auto Scaling Groups support up to one active instance refresh at a time. When this resource is updated, any existing refresh is cancelled.
     * > **NOTE:** Depending on health check settings and group size, an instance refresh may take a long time or fail. This resource does not wait for the instance refresh to complete.
     */
    @JvmName("mpgwkwrpkhbbhbgq")
    public suspend fun triggers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.triggers = mapped
    }

    internal fun build(): GroupInstanceRefreshArgs = GroupInstanceRefreshArgs(
        preferences = preferences,
        strategy = strategy ?: throw PulumiNullFieldException("strategy"),
        triggers = triggers,
    )
}
