@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin.inputs

import com.pulumi.aws.autoscaling.inputs.GroupInstanceRefreshPreferencesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property autoRollback Automatically rollback if instance refresh fails. Defaults to `false`. This option may only be set to `true` when specifying a `launch_template` or `mixed_instances_policy`.
 * @property checkpointDelay Number of seconds to wait after a checkpoint. Defaults to `3600`.
 * @property checkpointPercentages List of percentages for each checkpoint. Values must be unique and in ascending order. To replace all instances, the final number must be `100`.
 * @property instanceWarmup Number of seconds until a newly launched instance is configured and ready to use. Default behavior is to use the Auto Scaling Group's health check grace period.
 * @property minHealthyPercentage Specifies the lower limit on the number of instances that must be in the InService state with a healthy status during an instance replacement activity.
 * @property scaleInProtectedInstances Behavior when encountering instances protected from scale in are found. Available behaviors are `Refresh`, `Ignore`, and `Wait`. Default is `Ignore`.
 * @property skipMatching Replace instances that already have your desired configuration. Defaults to `false`.
 * @property standbyInstances Behavior when encountering instances in the `Standby` state in are found. Available behaviors are `Terminate`, `Ignore`, and `Wait`. Default is `Ignore`.
 */
public data class GroupInstanceRefreshPreferencesArgs(
    public val autoRollback: Output<Boolean>? = null,
    public val checkpointDelay: Output<String>? = null,
    public val checkpointPercentages: Output<List<Int>>? = null,
    public val instanceWarmup: Output<String>? = null,
    public val minHealthyPercentage: Output<Int>? = null,
    public val scaleInProtectedInstances: Output<String>? = null,
    public val skipMatching: Output<Boolean>? = null,
    public val standbyInstances: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.autoscaling.inputs.GroupInstanceRefreshPreferencesArgs> {
    override fun toJava(): com.pulumi.aws.autoscaling.inputs.GroupInstanceRefreshPreferencesArgs =
        com.pulumi.aws.autoscaling.inputs.GroupInstanceRefreshPreferencesArgs.builder()
            .autoRollback(autoRollback?.applyValue({ args0 -> args0 }))
            .checkpointDelay(checkpointDelay?.applyValue({ args0 -> args0 }))
            .checkpointPercentages(checkpointPercentages?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .instanceWarmup(instanceWarmup?.applyValue({ args0 -> args0 }))
            .minHealthyPercentage(minHealthyPercentage?.applyValue({ args0 -> args0 }))
            .scaleInProtectedInstances(scaleInProtectedInstances?.applyValue({ args0 -> args0 }))
            .skipMatching(skipMatching?.applyValue({ args0 -> args0 }))
            .standbyInstances(standbyInstances?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GroupInstanceRefreshPreferencesArgs].
 */
@PulumiTagMarker
public class GroupInstanceRefreshPreferencesArgsBuilder internal constructor() {
    private var autoRollback: Output<Boolean>? = null

    private var checkpointDelay: Output<String>? = null

    private var checkpointPercentages: Output<List<Int>>? = null

    private var instanceWarmup: Output<String>? = null

    private var minHealthyPercentage: Output<Int>? = null

    private var scaleInProtectedInstances: Output<String>? = null

    private var skipMatching: Output<Boolean>? = null

    private var standbyInstances: Output<String>? = null

    /**
     * @param value Automatically rollback if instance refresh fails. Defaults to `false`. This option may only be set to `true` when specifying a `launch_template` or `mixed_instances_policy`.
     */
    @JvmName("qxfbxsttciratwuo")
    public suspend fun autoRollback(`value`: Output<Boolean>) {
        this.autoRollback = value
    }

    /**
     * @param value Number of seconds to wait after a checkpoint. Defaults to `3600`.
     */
    @JvmName("nlrwmhgwrxoruvmw")
    public suspend fun checkpointDelay(`value`: Output<String>) {
        this.checkpointDelay = value
    }

    /**
     * @param value List of percentages for each checkpoint. Values must be unique and in ascending order. To replace all instances, the final number must be `100`.
     */
    @JvmName("eiurbosqqpnurxio")
    public suspend fun checkpointPercentages(`value`: Output<List<Int>>) {
        this.checkpointPercentages = value
    }

    @JvmName("ehfabxigwigxwtpn")
    public suspend fun checkpointPercentages(vararg values: Output<Int>) {
        this.checkpointPercentages = Output.all(values.asList())
    }

    /**
     * @param values List of percentages for each checkpoint. Values must be unique and in ascending order. To replace all instances, the final number must be `100`.
     */
    @JvmName("dpbxfipbdktuonjb")
    public suspend fun checkpointPercentages(values: List<Output<Int>>) {
        this.checkpointPercentages = Output.all(values)
    }

    /**
     * @param value Number of seconds until a newly launched instance is configured and ready to use. Default behavior is to use the Auto Scaling Group's health check grace period.
     */
    @JvmName("hxhidltwdnlqshax")
    public suspend fun instanceWarmup(`value`: Output<String>) {
        this.instanceWarmup = value
    }

    /**
     * @param value Specifies the lower limit on the number of instances that must be in the InService state with a healthy status during an instance replacement activity.
     */
    @JvmName("dkyrwskvixjbuwof")
    public suspend fun minHealthyPercentage(`value`: Output<Int>) {
        this.minHealthyPercentage = value
    }

    /**
     * @param value Behavior when encountering instances protected from scale in are found. Available behaviors are `Refresh`, `Ignore`, and `Wait`. Default is `Ignore`.
     */
    @JvmName("gaxfwlveluktilev")
    public suspend fun scaleInProtectedInstances(`value`: Output<String>) {
        this.scaleInProtectedInstances = value
    }

    /**
     * @param value Replace instances that already have your desired configuration. Defaults to `false`.
     */
    @JvmName("uxtlhyakjgkoxaoo")
    public suspend fun skipMatching(`value`: Output<Boolean>) {
        this.skipMatching = value
    }

    /**
     * @param value Behavior when encountering instances in the `Standby` state in are found. Available behaviors are `Terminate`, `Ignore`, and `Wait`. Default is `Ignore`.
     */
    @JvmName("sorxiyiieuptmmdv")
    public suspend fun standbyInstances(`value`: Output<String>) {
        this.standbyInstances = value
    }

    /**
     * @param value Automatically rollback if instance refresh fails. Defaults to `false`. This option may only be set to `true` when specifying a `launch_template` or `mixed_instances_policy`.
     */
    @JvmName("gpvlllgtgdncmwws")
    public suspend fun autoRollback(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRollback = mapped
    }

    /**
     * @param value Number of seconds to wait after a checkpoint. Defaults to `3600`.
     */
    @JvmName("thformmwfumnsuea")
    public suspend fun checkpointDelay(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.checkpointDelay = mapped
    }

    /**
     * @param value List of percentages for each checkpoint. Values must be unique and in ascending order. To replace all instances, the final number must be `100`.
     */
    @JvmName("qwmawujemuicdgal")
    public suspend fun checkpointPercentages(`value`: List<Int>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.checkpointPercentages = mapped
    }

    /**
     * @param values List of percentages for each checkpoint. Values must be unique and in ascending order. To replace all instances, the final number must be `100`.
     */
    @JvmName("eaogvbmoiybvxfej")
    public suspend fun checkpointPercentages(vararg values: Int) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.checkpointPercentages = mapped
    }

    /**
     * @param value Number of seconds until a newly launched instance is configured and ready to use. Default behavior is to use the Auto Scaling Group's health check grace period.
     */
    @JvmName("kopthwvbpjdytbra")
    public suspend fun instanceWarmup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceWarmup = mapped
    }

    /**
     * @param value Specifies the lower limit on the number of instances that must be in the InService state with a healthy status during an instance replacement activity.
     */
    @JvmName("iotopojxquyunety")
    public suspend fun minHealthyPercentage(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minHealthyPercentage = mapped
    }

    /**
     * @param value Behavior when encountering instances protected from scale in are found. Available behaviors are `Refresh`, `Ignore`, and `Wait`. Default is `Ignore`.
     */
    @JvmName("sicwutotvfjxicaf")
    public suspend fun scaleInProtectedInstances(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scaleInProtectedInstances = mapped
    }

    /**
     * @param value Replace instances that already have your desired configuration. Defaults to `false`.
     */
    @JvmName("wswnkufrtyvoggiu")
    public suspend fun skipMatching(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skipMatching = mapped
    }

    /**
     * @param value Behavior when encountering instances in the `Standby` state in are found. Available behaviors are `Terminate`, `Ignore`, and `Wait`. Default is `Ignore`.
     */
    @JvmName("yabutsbuwighqrdw")
    public suspend fun standbyInstances(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.standbyInstances = mapped
    }

    internal fun build(): GroupInstanceRefreshPreferencesArgs = GroupInstanceRefreshPreferencesArgs(
        autoRollback = autoRollback,
        checkpointDelay = checkpointDelay,
        checkpointPercentages = checkpointPercentages,
        instanceWarmup = instanceWarmup,
        minHealthyPercentage = minHealthyPercentage,
        scaleInProtectedInstances = scaleInProtectedInstances,
        skipMatching = skipMatching,
        standbyInstances = standbyInstances,
    )
}
