@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin.inputs

import com.pulumi.aws.autoscaling.inputs.GroupLaunchTemplateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property id ID of the launch template. Conflicts with `name`.
 * @property name Name of the launch template. Conflicts with `id`.
 * @property version Template version. Can be version number, `$Latest`, or `$Default`. (Default: `$Default`).
 */
public data class GroupLaunchTemplateArgs(
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.autoscaling.inputs.GroupLaunchTemplateArgs> {
    override fun toJava(): com.pulumi.aws.autoscaling.inputs.GroupLaunchTemplateArgs =
        com.pulumi.aws.autoscaling.inputs.GroupLaunchTemplateArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GroupLaunchTemplateArgs].
 */
@PulumiTagMarker
public class GroupLaunchTemplateArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value ID of the launch template. Conflicts with `name`.
     */
    @JvmName("mslraceahlamqjvx")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Name of the launch template. Conflicts with `id`.
     */
    @JvmName("ujjwwfjqmhmrscaj")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Template version. Can be version number, `$Latest`, or `$Default`. (Default: `$Default`).
     */
    @JvmName("uthrtckvpajwfroh")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value ID of the launch template. Conflicts with `name`.
     */
    @JvmName("xnvmmtftwhacwjag")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Name of the launch template. Conflicts with `id`.
     */
    @JvmName("ffpqqhdubqfykwme")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Template version. Can be version number, `$Latest`, or `$Default`. (Default: `$Default`).
     */
    @JvmName("ntowetmqhpqbnnkk")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): GroupLaunchTemplateArgs = GroupLaunchTemplateArgs(
        id = id,
        name = name,
        version = version,
    )
}
