@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin.inputs

import com.pulumi.aws.autoscaling.inputs.GroupMixedInstancesPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property instancesDistribution Nested argument containing settings on how to mix on-demand and Spot instances in the Auto Scaling group. Defined below.
 * @property launchTemplate Nested argument containing launch template settings along with the overrides to specify multiple instance types and weights. Defined below.
 */
public data class GroupMixedInstancesPolicyArgs(
    public val instancesDistribution: Output<GroupMixedInstancesPolicyInstancesDistributionArgs>? =
        null,
    public val launchTemplate: Output<GroupMixedInstancesPolicyLaunchTemplateArgs>,
) : ConvertibleToJava<com.pulumi.aws.autoscaling.inputs.GroupMixedInstancesPolicyArgs> {
    override fun toJava(): com.pulumi.aws.autoscaling.inputs.GroupMixedInstancesPolicyArgs =
        com.pulumi.aws.autoscaling.inputs.GroupMixedInstancesPolicyArgs.builder()
            .instancesDistribution(
                instancesDistribution?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .launchTemplate(
                launchTemplate.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [GroupMixedInstancesPolicyArgs].
 */
@PulumiTagMarker
public class GroupMixedInstancesPolicyArgsBuilder internal constructor() {
    private var instancesDistribution: Output<GroupMixedInstancesPolicyInstancesDistributionArgs>? =
        null

    private var launchTemplate: Output<GroupMixedInstancesPolicyLaunchTemplateArgs>? = null

    /**
     * @param value Nested argument containing settings on how to mix on-demand and Spot instances in the Auto Scaling group. Defined below.
     */
    @JvmName("ixsclhennvfnthwn")
    public suspend
    fun instancesDistribution(`value`: Output<GroupMixedInstancesPolicyInstancesDistributionArgs>) {
        this.instancesDistribution = value
    }

    /**
     * @param value Nested argument containing launch template settings along with the overrides to specify multiple instance types and weights. Defined below.
     */
    @JvmName("hrikxuilarerwuwe")
    public suspend fun launchTemplate(`value`: Output<GroupMixedInstancesPolicyLaunchTemplateArgs>) {
        this.launchTemplate = value
    }

    /**
     * @param value Nested argument containing settings on how to mix on-demand and Spot instances in the Auto Scaling group. Defined below.
     */
    @JvmName("wmydyhexnsuhmgbs")
    public suspend
    fun instancesDistribution(`value`: GroupMixedInstancesPolicyInstancesDistributionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instancesDistribution = mapped
    }

    /**
     * @param argument Nested argument containing settings on how to mix on-demand and Spot instances in the Auto Scaling group. Defined below.
     */
    @JvmName("xemjhmpyeyddpcen")
    public suspend
    fun instancesDistribution(argument: suspend GroupMixedInstancesPolicyInstancesDistributionArgsBuilder.() -> Unit) {
        val toBeMapped = GroupMixedInstancesPolicyInstancesDistributionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.instancesDistribution = mapped
    }

    /**
     * @param value Nested argument containing launch template settings along with the overrides to specify multiple instance types and weights. Defined below.
     */
    @JvmName("acgdtfbnnjspiqpl")
    public suspend fun launchTemplate(`value`: GroupMixedInstancesPolicyLaunchTemplateArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.launchTemplate = mapped
    }

    /**
     * @param argument Nested argument containing launch template settings along with the overrides to specify multiple instance types and weights. Defined below.
     */
    @JvmName("vkolvsrslpmhcbgd")
    public suspend
    fun launchTemplate(argument: suspend GroupMixedInstancesPolicyLaunchTemplateArgsBuilder.() -> Unit) {
        val toBeMapped = GroupMixedInstancesPolicyLaunchTemplateArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.launchTemplate = mapped
    }

    internal fun build(): GroupMixedInstancesPolicyArgs = GroupMixedInstancesPolicyArgs(
        instancesDistribution = instancesDistribution,
        launchTemplate = launchTemplate ?: throw PulumiNullFieldException("launchTemplate"),
    )
}
