@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin.inputs

import com.pulumi.aws.autoscaling.inputs.GroupMixedInstancesPolicyInstancesDistributionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property onDemandAllocationStrategy Strategy to use when launching on-demand instances. Valid values: `prioritized`, `lowest-price`. Default: `prioritized`.
 * @property onDemandBaseCapacity Absolute minimum amount of desired capacity that must be fulfilled by on-demand instances. Default: `0`.
 * @property onDemandPercentageAboveBaseCapacity Percentage split between on-demand and Spot instances above the base on-demand capacity. Default: `100`.
 * @property spotAllocationStrategy How to allocate capacity across the Spot pools. Valid values: `lowest-price`, `capacity-optimized`, `capacity-optimized-prioritized`, and `price-capacity-optimized`. Default: `lowest-price`.
 * @property spotInstancePools Number of Spot pools per availability zone to allocate capacity. EC2 Auto Scaling selects the cheapest Spot pools and evenly allocates Spot capacity across the number of Spot pools that you specify. Only available with `spot_allocation_strategy` set to `lowest-price`. Otherwise it must be set to `0`, if it has been defined before. Default: `2`.
 * @property spotMaxPrice Maximum price per unit hour that the user is willing to pay for the Spot instances. Default: an empty string which means the on-demand price.
 */
public data class GroupMixedInstancesPolicyInstancesDistributionArgs(
    public val onDemandAllocationStrategy: Output<String>? = null,
    public val onDemandBaseCapacity: Output<Int>? = null,
    public val onDemandPercentageAboveBaseCapacity: Output<Int>? = null,
    public val spotAllocationStrategy: Output<String>? = null,
    public val spotInstancePools: Output<Int>? = null,
    public val spotMaxPrice: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.autoscaling.inputs.GroupMixedInstancesPolicyInstancesDistributionArgs> {
    override fun toJava():
        com.pulumi.aws.autoscaling.inputs.GroupMixedInstancesPolicyInstancesDistributionArgs =
        com.pulumi.aws.autoscaling.inputs.GroupMixedInstancesPolicyInstancesDistributionArgs.builder()
            .onDemandAllocationStrategy(onDemandAllocationStrategy?.applyValue({ args0 -> args0 }))
            .onDemandBaseCapacity(onDemandBaseCapacity?.applyValue({ args0 -> args0 }))
            .onDemandPercentageAboveBaseCapacity(
                onDemandPercentageAboveBaseCapacity?.applyValue({ args0 ->
                    args0
                }),
            )
            .spotAllocationStrategy(spotAllocationStrategy?.applyValue({ args0 -> args0 }))
            .spotInstancePools(spotInstancePools?.applyValue({ args0 -> args0 }))
            .spotMaxPrice(spotMaxPrice?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GroupMixedInstancesPolicyInstancesDistributionArgs].
 */
@PulumiTagMarker
public class GroupMixedInstancesPolicyInstancesDistributionArgsBuilder internal constructor() {
    private var onDemandAllocationStrategy: Output<String>? = null

    private var onDemandBaseCapacity: Output<Int>? = null

    private var onDemandPercentageAboveBaseCapacity: Output<Int>? = null

    private var spotAllocationStrategy: Output<String>? = null

    private var spotInstancePools: Output<Int>? = null

    private var spotMaxPrice: Output<String>? = null

    /**
     * @param value Strategy to use when launching on-demand instances. Valid values: `prioritized`, `lowest-price`. Default: `prioritized`.
     */
    @JvmName("fknxcvvthmfpssha")
    public suspend fun onDemandAllocationStrategy(`value`: Output<String>) {
        this.onDemandAllocationStrategy = value
    }

    /**
     * @param value Absolute minimum amount of desired capacity that must be fulfilled by on-demand instances. Default: `0`.
     */
    @JvmName("xgccktdumpwboajg")
    public suspend fun onDemandBaseCapacity(`value`: Output<Int>) {
        this.onDemandBaseCapacity = value
    }

    /**
     * @param value Percentage split between on-demand and Spot instances above the base on-demand capacity. Default: `100`.
     */
    @JvmName("kyryaflgfksnnadj")
    public suspend fun onDemandPercentageAboveBaseCapacity(`value`: Output<Int>) {
        this.onDemandPercentageAboveBaseCapacity = value
    }

    /**
     * @param value How to allocate capacity across the Spot pools. Valid values: `lowest-price`, `capacity-optimized`, `capacity-optimized-prioritized`, and `price-capacity-optimized`. Default: `lowest-price`.
     */
    @JvmName("cdrluxtusqbummal")
    public suspend fun spotAllocationStrategy(`value`: Output<String>) {
        this.spotAllocationStrategy = value
    }

    /**
     * @param value Number of Spot pools per availability zone to allocate capacity. EC2 Auto Scaling selects the cheapest Spot pools and evenly allocates Spot capacity across the number of Spot pools that you specify. Only available with `spot_allocation_strategy` set to `lowest-price`. Otherwise it must be set to `0`, if it has been defined before. Default: `2`.
     */
    @JvmName("xuaawuvvmaxysdso")
    public suspend fun spotInstancePools(`value`: Output<Int>) {
        this.spotInstancePools = value
    }

    /**
     * @param value Maximum price per unit hour that the user is willing to pay for the Spot instances. Default: an empty string which means the on-demand price.
     */
    @JvmName("impaugfcjyvyvrin")
    public suspend fun spotMaxPrice(`value`: Output<String>) {
        this.spotMaxPrice = value
    }

    /**
     * @param value Strategy to use when launching on-demand instances. Valid values: `prioritized`, `lowest-price`. Default: `prioritized`.
     */
    @JvmName("ogwneovrusssgfyv")
    public suspend fun onDemandAllocationStrategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onDemandAllocationStrategy = mapped
    }

    /**
     * @param value Absolute minimum amount of desired capacity that must be fulfilled by on-demand instances. Default: `0`.
     */
    @JvmName("nusjcegotwrdjvkp")
    public suspend fun onDemandBaseCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onDemandBaseCapacity = mapped
    }

    /**
     * @param value Percentage split between on-demand and Spot instances above the base on-demand capacity. Default: `100`.
     */
    @JvmName("meqbhxlwkdjdkaaf")
    public suspend fun onDemandPercentageAboveBaseCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onDemandPercentageAboveBaseCapacity = mapped
    }

    /**
     * @param value How to allocate capacity across the Spot pools. Valid values: `lowest-price`, `capacity-optimized`, `capacity-optimized-prioritized`, and `price-capacity-optimized`. Default: `lowest-price`.
     */
    @JvmName("oytrahhpwbepayjq")
    public suspend fun spotAllocationStrategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spotAllocationStrategy = mapped
    }

    /**
     * @param value Number of Spot pools per availability zone to allocate capacity. EC2 Auto Scaling selects the cheapest Spot pools and evenly allocates Spot capacity across the number of Spot pools that you specify. Only available with `spot_allocation_strategy` set to `lowest-price`. Otherwise it must be set to `0`, if it has been defined before. Default: `2`.
     */
    @JvmName("lfprkdakbfuabwbx")
    public suspend fun spotInstancePools(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spotInstancePools = mapped
    }

    /**
     * @param value Maximum price per unit hour that the user is willing to pay for the Spot instances. Default: an empty string which means the on-demand price.
     */
    @JvmName("qainpowqbkreqwwd")
    public suspend fun spotMaxPrice(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spotMaxPrice = mapped
    }

    internal fun build(): GroupMixedInstancesPolicyInstancesDistributionArgs =
        GroupMixedInstancesPolicyInstancesDistributionArgs(
            onDemandAllocationStrategy = onDemandAllocationStrategy,
            onDemandBaseCapacity = onDemandBaseCapacity,
            onDemandPercentageAboveBaseCapacity = onDemandPercentageAboveBaseCapacity,
            spotAllocationStrategy = spotAllocationStrategy,
            spotInstancePools = spotInstancePools,
            spotMaxPrice = spotMaxPrice,
        )
}
