@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin.inputs

import com.pulumi.aws.autoscaling.inputs.GroupMixedInstancesPolicyLaunchTemplateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property launchTemplateSpecification Override the instance launch template specification in the Launch Template.
 * @property overrides List of nested arguments provides the ability to specify multiple instance types. This will override the same parameter in the launch template. For on-demand instances, Auto Scaling considers the order of preference of instance types to launch based on the order specified in the overrides list. Defined below.
 */
public data class GroupMixedInstancesPolicyLaunchTemplateArgs(
    public val launchTemplateSpecification:
    Output<GroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecificationArgs>,
    public val overrides: Output<List<GroupMixedInstancesPolicyLaunchTemplateOverrideArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.autoscaling.inputs.GroupMixedInstancesPolicyLaunchTemplateArgs> {
    override fun toJava():
        com.pulumi.aws.autoscaling.inputs.GroupMixedInstancesPolicyLaunchTemplateArgs =
        com.pulumi.aws.autoscaling.inputs.GroupMixedInstancesPolicyLaunchTemplateArgs.builder()
            .launchTemplateSpecification(
                launchTemplateSpecification.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .overrides(
                overrides?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [GroupMixedInstancesPolicyLaunchTemplateArgs].
 */
@PulumiTagMarker
public class GroupMixedInstancesPolicyLaunchTemplateArgsBuilder internal constructor() {
    private var launchTemplateSpecification:
        Output<GroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecificationArgs>? = null

    private var overrides: Output<List<GroupMixedInstancesPolicyLaunchTemplateOverrideArgs>>? = null

    /**
     * @param value Override the instance launch template specification in the Launch Template.
     */
    @JvmName("bctrxvkhsuutthrj")
    public suspend
    fun launchTemplateSpecification(`value`: Output<GroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecificationArgs>) {
        this.launchTemplateSpecification = value
    }

    /**
     * @param value List of nested arguments provides the ability to specify multiple instance types. This will override the same parameter in the launch template. For on-demand instances, Auto Scaling considers the order of preference of instance types to launch based on the order specified in the overrides list. Defined below.
     */
    @JvmName("aaxpgiajjktyhhew")
    public suspend
    fun overrides(`value`: Output<List<GroupMixedInstancesPolicyLaunchTemplateOverrideArgs>>) {
        this.overrides = value
    }

    @JvmName("wwhgsvauesregpve")
    public suspend fun overrides(
        vararg
        values: Output<GroupMixedInstancesPolicyLaunchTemplateOverrideArgs>,
    ) {
        this.overrides = Output.all(values.asList())
    }

    /**
     * @param values List of nested arguments provides the ability to specify multiple instance types. This will override the same parameter in the launch template. For on-demand instances, Auto Scaling considers the order of preference of instance types to launch based on the order specified in the overrides list. Defined below.
     */
    @JvmName("xbglyqojawbdxcbl")
    public suspend
    fun overrides(values: List<Output<GroupMixedInstancesPolicyLaunchTemplateOverrideArgs>>) {
        this.overrides = Output.all(values)
    }

    /**
     * @param value Override the instance launch template specification in the Launch Template.
     */
    @JvmName("yydvoqdtrjjbfnee")
    public suspend
    fun launchTemplateSpecification(`value`: GroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecificationArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.launchTemplateSpecification = mapped
    }

    /**
     * @param argument Override the instance launch template specification in the Launch Template.
     */
    @JvmName("jypmxprjyixcvgos")
    public suspend
    fun launchTemplateSpecification(argument: suspend GroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecificationArgsBuilder.() -> Unit) {
        val toBeMapped =
            GroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecificationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.launchTemplateSpecification = mapped
    }

    /**
     * @param value List of nested arguments provides the ability to specify multiple instance types. This will override the same parameter in the launch template. For on-demand instances, Auto Scaling considers the order of preference of instance types to launch based on the order specified in the overrides list. Defined below.
     */
    @JvmName("fsgphnwvpiirojtu")
    public suspend
    fun overrides(`value`: List<GroupMixedInstancesPolicyLaunchTemplateOverrideArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.overrides = mapped
    }

    /**
     * @param argument List of nested arguments provides the ability to specify multiple instance types. This will override the same parameter in the launch template. For on-demand instances, Auto Scaling considers the order of preference of instance types to launch based on the order specified in the overrides list. Defined below.
     */
    @JvmName("avcfqomxmwtbcirs")
    public suspend
    fun overrides(argument: List<suspend GroupMixedInstancesPolicyLaunchTemplateOverrideArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GroupMixedInstancesPolicyLaunchTemplateOverrideArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.overrides = mapped
    }

    /**
     * @param argument List of nested arguments provides the ability to specify multiple instance types. This will override the same parameter in the launch template. For on-demand instances, Auto Scaling considers the order of preference of instance types to launch based on the order specified in the overrides list. Defined below.
     */
    @JvmName("nxrgeiquebxgawlh")
    public suspend fun overrides(
        vararg
        argument: suspend GroupMixedInstancesPolicyLaunchTemplateOverrideArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            GroupMixedInstancesPolicyLaunchTemplateOverrideArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.overrides = mapped
    }

    /**
     * @param argument List of nested arguments provides the ability to specify multiple instance types. This will override the same parameter in the launch template. For on-demand instances, Auto Scaling considers the order of preference of instance types to launch based on the order specified in the overrides list. Defined below.
     */
    @JvmName("ragirvoqplnjimrw")
    public suspend
    fun overrides(argument: suspend GroupMixedInstancesPolicyLaunchTemplateOverrideArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                GroupMixedInstancesPolicyLaunchTemplateOverrideArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.overrides = mapped
    }

    /**
     * @param values List of nested arguments provides the ability to specify multiple instance types. This will override the same parameter in the launch template. For on-demand instances, Auto Scaling considers the order of preference of instance types to launch based on the order specified in the overrides list. Defined below.
     */
    @JvmName("vfmmddhklcfrfmpg")
    public suspend fun overrides(vararg values: GroupMixedInstancesPolicyLaunchTemplateOverrideArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.overrides = mapped
    }

    internal fun build(): GroupMixedInstancesPolicyLaunchTemplateArgs =
        GroupMixedInstancesPolicyLaunchTemplateArgs(
            launchTemplateSpecification = launchTemplateSpecification ?: throw
                PulumiNullFieldException("launchTemplateSpecification"),
            overrides = overrides,
        )
}
