@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin.inputs

import com.pulumi.aws.autoscaling.inputs.GroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecificationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property launchTemplateId ID of the launch template. Conflicts with `launch_template_name`.
 * @property launchTemplateName Name of the launch template. Conflicts with `launch_template_id`.
 * @property version Template version. Can be version number, `$Latest`, or `$Default`. (Default: `$Default`).
 */
public data class GroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecificationArgs(
    public val launchTemplateId: Output<String>? = null,
    public val launchTemplateName: Output<String>? = null,
    public val version: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.autoscaling.inputs.GroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecificationArgs> {
    override fun toJava():
        com.pulumi.aws.autoscaling.inputs.GroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecificationArgs =
        com.pulumi.aws.autoscaling.inputs.GroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecificationArgs.builder()
            .launchTemplateId(launchTemplateId?.applyValue({ args0 -> args0 }))
            .launchTemplateName(launchTemplateName?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecificationArgs].
 */
@PulumiTagMarker
public class GroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecificationArgsBuilder internal
constructor() {
    private var launchTemplateId: Output<String>? = null

    private var launchTemplateName: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value ID of the launch template. Conflicts with `launch_template_name`.
     */
    @JvmName("syuxkjkksshbuudg")
    public suspend fun launchTemplateId(`value`: Output<String>) {
        this.launchTemplateId = value
    }

    /**
     * @param value Name of the launch template. Conflicts with `launch_template_id`.
     */
    @JvmName("pgltborgnrqunlca")
    public suspend fun launchTemplateName(`value`: Output<String>) {
        this.launchTemplateName = value
    }

    /**
     * @param value Template version. Can be version number, `$Latest`, or `$Default`. (Default: `$Default`).
     */
    @JvmName("buoaiqvxhaaccjwk")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value ID of the launch template. Conflicts with `launch_template_name`.
     */
    @JvmName("wmwmiuvplnoccmnc")
    public suspend fun launchTemplateId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.launchTemplateId = mapped
    }

    /**
     * @param value Name of the launch template. Conflicts with `launch_template_id`.
     */
    @JvmName("egjcyjusvmwxanao")
    public suspend fun launchTemplateName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.launchTemplateName = mapped
    }

    /**
     * @param value Template version. Can be version number, `$Latest`, or `$Default`. (Default: `$Default`).
     */
    @JvmName("wbrvobeeqmqbubgb")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): GroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecificationArgs =
        GroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecificationArgs(
            launchTemplateId = launchTemplateId,
            launchTemplateName = launchTemplateName,
            version = version,
        )
}
