@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin.inputs

import com.pulumi.aws.autoscaling.inputs.GroupMixedInstancesPolicyLaunchTemplateOverrideArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property instanceRequirements Override the instance type in the Launch Template with instance types that satisfy the requirements.
 * @property instanceType Override the instance type in the Launch Template.
 * @property launchTemplateSpecification Override the instance launch template specification in the Launch Template.
 * @property weightedCapacity Number of capacity units, which gives the instance type a proportional weight to other instance types.
 */
public data class GroupMixedInstancesPolicyLaunchTemplateOverrideArgs(
    public val instanceRequirements:
    Output<GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsArgs>? = null,
    public val instanceType: Output<String>? = null,
    public val launchTemplateSpecification:
    Output<GroupMixedInstancesPolicyLaunchTemplateOverrideLaunchTemplateSpecificationArgs>? =
        null,
    public val weightedCapacity: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.autoscaling.inputs.GroupMixedInstancesPolicyLaunchTemplateOverrideArgs> {
    override fun toJava():
        com.pulumi.aws.autoscaling.inputs.GroupMixedInstancesPolicyLaunchTemplateOverrideArgs =
        com.pulumi.aws.autoscaling.inputs.GroupMixedInstancesPolicyLaunchTemplateOverrideArgs.builder()
            .instanceRequirements(
                instanceRequirements?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .instanceType(instanceType?.applyValue({ args0 -> args0 }))
            .launchTemplateSpecification(
                launchTemplateSpecification?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .weightedCapacity(weightedCapacity?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GroupMixedInstancesPolicyLaunchTemplateOverrideArgs].
 */
@PulumiTagMarker
public class GroupMixedInstancesPolicyLaunchTemplateOverrideArgsBuilder internal constructor() {
    private var instanceRequirements:
        Output<GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsArgs>? = null

    private var instanceType: Output<String>? = null

    private var launchTemplateSpecification:
        Output<GroupMixedInstancesPolicyLaunchTemplateOverrideLaunchTemplateSpecificationArgs>? = null

    private var weightedCapacity: Output<String>? = null

    /**
     * @param value Override the instance type in the Launch Template with instance types that satisfy the requirements.
     */
    @JvmName("yfkotssokcxiewcy")
    public suspend
    fun instanceRequirements(`value`: Output<GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsArgs>) {
        this.instanceRequirements = value
    }

    /**
     * @param value Override the instance type in the Launch Template.
     */
    @JvmName("hbesqrqcccotagqv")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value Override the instance launch template specification in the Launch Template.
     */
    @JvmName("gxljmvpgbdkpqahn")
    public suspend
    fun launchTemplateSpecification(`value`: Output<GroupMixedInstancesPolicyLaunchTemplateOverrideLaunchTemplateSpecificationArgs>) {
        this.launchTemplateSpecification = value
    }

    /**
     * @param value Number of capacity units, which gives the instance type a proportional weight to other instance types.
     */
    @JvmName("phjxrjclspfogxjc")
    public suspend fun weightedCapacity(`value`: Output<String>) {
        this.weightedCapacity = value
    }

    /**
     * @param value Override the instance type in the Launch Template with instance types that satisfy the requirements.
     */
    @JvmName("nplaqygonljmbxjk")
    public suspend
    fun instanceRequirements(`value`: GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceRequirements = mapped
    }

    /**
     * @param argument Override the instance type in the Launch Template with instance types that satisfy the requirements.
     */
    @JvmName("ktydrwwiaflirngf")
    public suspend
    fun instanceRequirements(argument: suspend GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsArgsBuilder.() -> Unit) {
        val toBeMapped =
            GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.instanceRequirements = mapped
    }

    /**
     * @param value Override the instance type in the Launch Template.
     */
    @JvmName("tqxkwrsamvpdtweu")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value Override the instance launch template specification in the Launch Template.
     */
    @JvmName("ydbqadulghkuyiht")
    public suspend
    fun launchTemplateSpecification(`value`: GroupMixedInstancesPolicyLaunchTemplateOverrideLaunchTemplateSpecificationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.launchTemplateSpecification = mapped
    }

    /**
     * @param argument Override the instance launch template specification in the Launch Template.
     */
    @JvmName("ikyffrttgupjnoih")
    public suspend
    fun launchTemplateSpecification(argument: suspend GroupMixedInstancesPolicyLaunchTemplateOverrideLaunchTemplateSpecificationArgsBuilder.() -> Unit) {
        val toBeMapped =
            GroupMixedInstancesPolicyLaunchTemplateOverrideLaunchTemplateSpecificationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.launchTemplateSpecification = mapped
    }

    /**
     * @param value Number of capacity units, which gives the instance type a proportional weight to other instance types.
     */
    @JvmName("lebcmcxwvlvktlcg")
    public suspend fun weightedCapacity(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weightedCapacity = mapped
    }

    internal fun build(): GroupMixedInstancesPolicyLaunchTemplateOverrideArgs =
        GroupMixedInstancesPolicyLaunchTemplateOverrideArgs(
            instanceRequirements = instanceRequirements,
            instanceType = instanceType,
            launchTemplateSpecification = launchTemplateSpecification,
            weightedCapacity = weightedCapacity,
        )
}
