@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin.inputs

import com.pulumi.aws.autoscaling.inputs.GroupTrafficSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property identifier Identifies the traffic source. For Application Load Balancers, Gateway Load Balancers, Network Load Balancers, and VPC Lattice, this will be the Amazon Resource Name (ARN) for a target group in this account and Region. For Classic Load Balancers, this will be the name of the Classic Load Balancer in this account and Region.
 * @property type Provides additional context for the value of Identifier.
 * The following lists the valid values:
 * `elb` if `identifier` is the name of a Classic Load Balancer.
 * `elbv2` if `identifier` is the ARN of an Application Load Balancer, Gateway Load Balancer, or Network Load Balancer target group.
 * `vpc-lattice` if `identifier` is the ARN of a VPC Lattice target group.
 */
public data class GroupTrafficSourceArgs(
    public val identifier: Output<String>,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.autoscaling.inputs.GroupTrafficSourceArgs> {
    override fun toJava(): com.pulumi.aws.autoscaling.inputs.GroupTrafficSourceArgs =
        com.pulumi.aws.autoscaling.inputs.GroupTrafficSourceArgs.builder()
            .identifier(identifier.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GroupTrafficSourceArgs].
 */
@PulumiTagMarker
public class GroupTrafficSourceArgsBuilder internal constructor() {
    private var identifier: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Identifies the traffic source. For Application Load Balancers, Gateway Load Balancers, Network Load Balancers, and VPC Lattice, this will be the Amazon Resource Name (ARN) for a target group in this account and Region. For Classic Load Balancers, this will be the name of the Classic Load Balancer in this account and Region.
     */
    @JvmName("bxywdvwxajauiuoq")
    public suspend fun identifier(`value`: Output<String>) {
        this.identifier = value
    }

    /**
     * @param value Provides additional context for the value of Identifier.
     * The following lists the valid values:
     * `elb` if `identifier` is the name of a Classic Load Balancer.
     * `elbv2` if `identifier` is the ARN of an Application Load Balancer, Gateway Load Balancer, or Network Load Balancer target group.
     * `vpc-lattice` if `identifier` is the ARN of a VPC Lattice target group.
     */
    @JvmName("pvtmbsrwrhcpvypx")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Identifies the traffic source. For Application Load Balancers, Gateway Load Balancers, Network Load Balancers, and VPC Lattice, this will be the Amazon Resource Name (ARN) for a target group in this account and Region. For Classic Load Balancers, this will be the name of the Classic Load Balancer in this account and Region.
     */
    @JvmName("dxreaxaftikaxjji")
    public suspend fun identifier(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.identifier = mapped
    }

    /**
     * @param value Provides additional context for the value of Identifier.
     * The following lists the valid values:
     * `elb` if `identifier` is the name of a Classic Load Balancer.
     * `elbv2` if `identifier` is the ARN of an Application Load Balancer, Gateway Load Balancer, or Network Load Balancer target group.
     * `vpc-lattice` if `identifier` is the ARN of a VPC Lattice target group.
     */
    @JvmName("udrcwvuydhhlgcca")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): GroupTrafficSourceArgs = GroupTrafficSourceArgs(
        identifier = identifier ?: throw PulumiNullFieldException("identifier"),
        type = type,
    )
}
