@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin.inputs

import com.pulumi.aws.autoscaling.inputs.GroupWarmPoolArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property instanceReusePolicy Whether instances in the Auto Scaling group can be returned to the warm pool on scale in. The default is to terminate instances in the Auto Scaling group when the group scales in.
 * @property maxGroupPreparedCapacity Total maximum number of instances that are allowed to be in the warm pool or in any state except Terminated for the Auto Scaling group.
 * @property minSize Minimum number of instances to maintain in the warm pool. This helps you to ensure that there is always a certain number of warmed instances available to handle traffic spikes. Defaults to 0 if not specified.
 * @property poolState Sets the instance state to transition to after the lifecycle hooks finish. Valid values are: Stopped (default), Running or Hibernated.
 */
public data class GroupWarmPoolArgs(
    public val instanceReusePolicy: Output<GroupWarmPoolInstanceReusePolicyArgs>? = null,
    public val maxGroupPreparedCapacity: Output<Int>? = null,
    public val minSize: Output<Int>? = null,
    public val poolState: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.autoscaling.inputs.GroupWarmPoolArgs> {
    override fun toJava(): com.pulumi.aws.autoscaling.inputs.GroupWarmPoolArgs =
        com.pulumi.aws.autoscaling.inputs.GroupWarmPoolArgs.builder()
            .instanceReusePolicy(
                instanceReusePolicy?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .maxGroupPreparedCapacity(maxGroupPreparedCapacity?.applyValue({ args0 -> args0 }))
            .minSize(minSize?.applyValue({ args0 -> args0 }))
            .poolState(poolState?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GroupWarmPoolArgs].
 */
@PulumiTagMarker
public class GroupWarmPoolArgsBuilder internal constructor() {
    private var instanceReusePolicy: Output<GroupWarmPoolInstanceReusePolicyArgs>? = null

    private var maxGroupPreparedCapacity: Output<Int>? = null

    private var minSize: Output<Int>? = null

    private var poolState: Output<String>? = null

    /**
     * @param value Whether instances in the Auto Scaling group can be returned to the warm pool on scale in. The default is to terminate instances in the Auto Scaling group when the group scales in.
     */
    @JvmName("gorkrutuqjpgiqry")
    public suspend fun instanceReusePolicy(`value`: Output<GroupWarmPoolInstanceReusePolicyArgs>) {
        this.instanceReusePolicy = value
    }

    /**
     * @param value Total maximum number of instances that are allowed to be in the warm pool or in any state except Terminated for the Auto Scaling group.
     */
    @JvmName("tlmtyrnhhpbtitjy")
    public suspend fun maxGroupPreparedCapacity(`value`: Output<Int>) {
        this.maxGroupPreparedCapacity = value
    }

    /**
     * @param value Minimum number of instances to maintain in the warm pool. This helps you to ensure that there is always a certain number of warmed instances available to handle traffic spikes. Defaults to 0 if not specified.
     */
    @JvmName("syklfsrekjjjbeve")
    public suspend fun minSize(`value`: Output<Int>) {
        this.minSize = value
    }

    /**
     * @param value Sets the instance state to transition to after the lifecycle hooks finish. Valid values are: Stopped (default), Running or Hibernated.
     */
    @JvmName("jsqppujmdiicvkgm")
    public suspend fun poolState(`value`: Output<String>) {
        this.poolState = value
    }

    /**
     * @param value Whether instances in the Auto Scaling group can be returned to the warm pool on scale in. The default is to terminate instances in the Auto Scaling group when the group scales in.
     */
    @JvmName("vqldceluogganlru")
    public suspend fun instanceReusePolicy(`value`: GroupWarmPoolInstanceReusePolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceReusePolicy = mapped
    }

    /**
     * @param argument Whether instances in the Auto Scaling group can be returned to the warm pool on scale in. The default is to terminate instances in the Auto Scaling group when the group scales in.
     */
    @JvmName("ppncegrkmhvqalqo")
    public suspend
    fun instanceReusePolicy(argument: suspend GroupWarmPoolInstanceReusePolicyArgsBuilder.() -> Unit) {
        val toBeMapped = GroupWarmPoolInstanceReusePolicyArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.instanceReusePolicy = mapped
    }

    /**
     * @param value Total maximum number of instances that are allowed to be in the warm pool or in any state except Terminated for the Auto Scaling group.
     */
    @JvmName("srdtksjjtvxsqkap")
    public suspend fun maxGroupPreparedCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxGroupPreparedCapacity = mapped
    }

    /**
     * @param value Minimum number of instances to maintain in the warm pool. This helps you to ensure that there is always a certain number of warmed instances available to handle traffic spikes. Defaults to 0 if not specified.
     */
    @JvmName("uvpvinigqkcudhsq")
    public suspend fun minSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minSize = mapped
    }

    /**
     * @param value Sets the instance state to transition to after the lifecycle hooks finish. Valid values are: Stopped (default), Running or Hibernated.
     */
    @JvmName("vjkkbvekphuqkhup")
    public suspend fun poolState(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.poolState = mapped
    }

    internal fun build(): GroupWarmPoolArgs = GroupWarmPoolArgs(
        instanceReusePolicy = instanceReusePolicy,
        maxGroupPreparedCapacity = maxGroupPreparedCapacity,
        minSize = minSize,
        poolState = poolState,
    )
}
