@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin.inputs

import com.pulumi.aws.autoscaling.inputs.PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedCapacityMetricSpecificationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property metricDataQueries List of up to 10 structures that defines custom capacity metric in predictive scaling policy
 */
public data class
PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedCapacityMetricSpecificationArgs(
    public val metricDataQueries:
    Output<List<PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedCapacityMetricSpecificationMetricDataQueryArgs>>,
) :
    ConvertibleToJava<com.pulumi.aws.autoscaling.inputs.PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedCapacityMetricSpecificationArgs> {
    override fun toJava():
        com.pulumi.aws.autoscaling.inputs.PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedCapacityMetricSpecificationArgs =
        com.pulumi.aws.autoscaling.inputs.PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedCapacityMetricSpecificationArgs.builder()
            .metricDataQueries(
                metricDataQueries.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedCapacityMetricSpecificationArgs].
 */
@PulumiTagMarker
public class
PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedCapacityMetricSpecificationArgsBuilder
internal constructor() {
    private var metricDataQueries:
        Output<List<PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedCapacityMetricSpecificationMetricDataQueryArgs>>? =
        null

    /**
     * @param value List of up to 10 structures that defines custom capacity metric in predictive scaling policy
     */
    @JvmName("rujsapmnwrpamxlp")
    public suspend
    fun metricDataQueries(`value`: Output<List<PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedCapacityMetricSpecificationMetricDataQueryArgs>>) {
        this.metricDataQueries = value
    }

    @JvmName("eukfnjbpoepnunyn")
    public suspend fun metricDataQueries(
        vararg
        values: Output<PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedCapacityMetricSpecificationMetricDataQueryArgs>,
    ) {
        this.metricDataQueries = Output.all(values.asList())
    }

    /**
     * @param values List of up to 10 structures that defines custom capacity metric in predictive scaling policy
     */
    @JvmName("lqshcilhmsxylykm")
    public suspend
    fun metricDataQueries(values: List<Output<PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedCapacityMetricSpecificationMetricDataQueryArgs>>) {
        this.metricDataQueries = Output.all(values)
    }

    /**
     * @param value List of up to 10 structures that defines custom capacity metric in predictive scaling policy
     */
    @JvmName("qkejognfvweatsjm")
    public suspend
    fun metricDataQueries(`value`: List<PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedCapacityMetricSpecificationMetricDataQueryArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metricDataQueries = mapped
    }

    /**
     * @param argument List of up to 10 structures that defines custom capacity metric in predictive scaling policy
     */
    @JvmName("nbbopsiwycgaxysl")
    public suspend
    fun metricDataQueries(argument: List<suspend PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedCapacityMetricSpecificationMetricDataQueryArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedCapacityMetricSpecificationMetricDataQueryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.metricDataQueries = mapped
    }

    /**
     * @param argument List of up to 10 structures that defines custom capacity metric in predictive scaling policy
     */
    @JvmName("txbeftgxfwasaheh")
    public suspend fun metricDataQueries(
        vararg
        argument: suspend PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedCapacityMetricSpecificationMetricDataQueryArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedCapacityMetricSpecificationMetricDataQueryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.metricDataQueries = mapped
    }

    /**
     * @param argument List of up to 10 structures that defines custom capacity metric in predictive scaling policy
     */
    @JvmName("hspstvjcwsesderc")
    public suspend
    fun metricDataQueries(argument: suspend PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedCapacityMetricSpecificationMetricDataQueryArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedCapacityMetricSpecificationMetricDataQueryArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.metricDataQueries = mapped
    }

    /**
     * @param values List of up to 10 structures that defines custom capacity metric in predictive scaling policy
     */
    @JvmName("bdleevxgkwlbhdxr")
    public suspend fun metricDataQueries(
        vararg
        values: PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedCapacityMetricSpecificationMetricDataQueryArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metricDataQueries = mapped
    }

    internal fun build():
        PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedCapacityMetricSpecificationArgs =
        PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedCapacityMetricSpecificationArgs(
            metricDataQueries = metricDataQueries ?: throw PulumiNullFieldException("metricDataQueries"),
        )
}
