@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin.inputs

import com.pulumi.aws.autoscaling.inputs.PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedCapacityMetricSpecificationMetricDataQueryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property expression Math expression used on the returned metric. You must specify either `expression` or `metric_stat`, but not both.
 * @property id Short name for the metric used in predictive scaling policy.
 * @property label Human-readable label for this metric or expression.
 * @property metricStat Structure that defines CloudWatch metric to be used in predictive scaling policy. You must specify either `expression` or `metric_stat`, but not both.
 * @property returnData Boolean that indicates whether to return the timestamps and raw data values of this metric, the default is true
 */
public data class
PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedCapacityMetricSpecificationMetricDataQueryArgs(
    public val expression: Output<String>? = null,
    public val id: Output<String>,
    public val label: Output<String>? = null,
    public val metricStat:
    Output<PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedCapacityMetricSpecificationMetricDataQueryMetricStatArgs>? =
        null,
    public val returnData: Output<Boolean>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.autoscaling.inputs.PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedCapacityMetricSpecificationMetricDataQueryArgs> {
    override fun toJava():
        com.pulumi.aws.autoscaling.inputs.PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedCapacityMetricSpecificationMetricDataQueryArgs =
        com.pulumi.aws.autoscaling.inputs.PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedCapacityMetricSpecificationMetricDataQueryArgs.builder()
            .expression(expression?.applyValue({ args0 -> args0 }))
            .id(id.applyValue({ args0 -> args0 }))
            .label(label?.applyValue({ args0 -> args0 }))
            .metricStat(metricStat?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .returnData(returnData?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedCapacityMetricSpecificationMetricDataQueryArgs].
 */
@PulumiTagMarker
public class
PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedCapacityMetricSpecificationMetricDataQueryArgsBuilder
internal constructor() {
    private var expression: Output<String>? = null

    private var id: Output<String>? = null

    private var label: Output<String>? = null

    private var metricStat:
        Output<PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedCapacityMetricSpecificationMetricDataQueryMetricStatArgs>? =
        null

    private var returnData: Output<Boolean>? = null

    /**
     * @param value Math expression used on the returned metric. You must specify either `expression` or `metric_stat`, but not both.
     */
    @JvmName("giesneafankwdmge")
    public suspend fun expression(`value`: Output<String>) {
        this.expression = value
    }

    /**
     * @param value Short name for the metric used in predictive scaling policy.
     */
    @JvmName("cevgnblgxswwhnyl")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Human-readable label for this metric or expression.
     */
    @JvmName("ypribuenrwxvvkfa")
    public suspend fun label(`value`: Output<String>) {
        this.label = value
    }

    /**
     * @param value Structure that defines CloudWatch metric to be used in predictive scaling policy. You must specify either `expression` or `metric_stat`, but not both.
     */
    @JvmName("tpgxtsmusengusuy")
    public suspend
    fun metricStat(`value`: Output<PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedCapacityMetricSpecificationMetricDataQueryMetricStatArgs>) {
        this.metricStat = value
    }

    /**
     * @param value Boolean that indicates whether to return the timestamps and raw data values of this metric, the default is true
     */
    @JvmName("kbjtrrogcnafoklh")
    public suspend fun returnData(`value`: Output<Boolean>) {
        this.returnData = value
    }

    /**
     * @param value Math expression used on the returned metric. You must specify either `expression` or `metric_stat`, but not both.
     */
    @JvmName("rnfnwyucyroofvmv")
    public suspend fun expression(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expression = mapped
    }

    /**
     * @param value Short name for the metric used in predictive scaling policy.
     */
    @JvmName("uixaxdnjjfareubq")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Human-readable label for this metric or expression.
     */
    @JvmName("psxqyofsugthvinp")
    public suspend fun label(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.label = mapped
    }

    /**
     * @param value Structure that defines CloudWatch metric to be used in predictive scaling policy. You must specify either `expression` or `metric_stat`, but not both.
     */
    @JvmName("bldyssifthuyrbjh")
    public suspend
    fun metricStat(`value`: PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedCapacityMetricSpecificationMetricDataQueryMetricStatArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metricStat = mapped
    }

    /**
     * @param argument Structure that defines CloudWatch metric to be used in predictive scaling policy. You must specify either `expression` or `metric_stat`, but not both.
     */
    @JvmName("sqeyjreyaimcrgvw")
    public suspend
    fun metricStat(argument: suspend PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedCapacityMetricSpecificationMetricDataQueryMetricStatArgsBuilder.() -> Unit) {
        val toBeMapped =
            PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedCapacityMetricSpecificationMetricDataQueryMetricStatArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.metricStat = mapped
    }

    /**
     * @param value Boolean that indicates whether to return the timestamps and raw data values of this metric, the default is true
     */
    @JvmName("srghntuxibendcjx")
    public suspend fun returnData(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.returnData = mapped
    }

    internal fun build():
        PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedCapacityMetricSpecificationMetricDataQueryArgs =
        PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedCapacityMetricSpecificationMetricDataQueryArgs(
            expression = expression,
            id = id ?: throw PulumiNullFieldException("id"),
            label = label,
            metricStat = metricStat,
            returnData = returnData,
        )
}
