@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin.inputs

import com.pulumi.aws.autoscaling.inputs.PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedLoadMetricSpecificationMetricDataQueryMetricStatArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property metric Structure that defines the CloudWatch metric to return, including the metric name, namespace, and dimensions.
 * @property stat Statistic of the metrics to return.
 * @property unit Unit of the metrics to return.
 */
public data class
PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedLoadMetricSpecificationMetricDataQueryMetricStatArgs(
    public val metric:
    Output<PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedLoadMetricSpecificationMetricDataQueryMetricStatMetricArgs>,
    public val stat: Output<String>,
    public val unit: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.autoscaling.inputs.PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedLoadMetricSpecificationMetricDataQueryMetricStatArgs> {
    override fun toJava():
        com.pulumi.aws.autoscaling.inputs.PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedLoadMetricSpecificationMetricDataQueryMetricStatArgs =
        com.pulumi.aws.autoscaling.inputs.PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedLoadMetricSpecificationMetricDataQueryMetricStatArgs.builder()
            .metric(metric.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .stat(stat.applyValue({ args0 -> args0 }))
            .unit(unit?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedLoadMetricSpecificationMetricDataQueryMetricStatArgs].
 */
@PulumiTagMarker
public class
PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedLoadMetricSpecificationMetricDataQueryMetricStatArgsBuilder
internal constructor() {
    private var metric:
        Output<PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedLoadMetricSpecificationMetricDataQueryMetricStatMetricArgs>? =
        null

    private var stat: Output<String>? = null

    private var unit: Output<String>? = null

    /**
     * @param value Structure that defines the CloudWatch metric to return, including the metric name, namespace, and dimensions.
     */
    @JvmName("pfyrjawlqfrpuwpj")
    public suspend
    fun metric(`value`: Output<PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedLoadMetricSpecificationMetricDataQueryMetricStatMetricArgs>) {
        this.metric = value
    }

    /**
     * @param value Statistic of the metrics to return.
     */
    @JvmName("vaxolbtfeovbgmli")
    public suspend fun stat(`value`: Output<String>) {
        this.stat = value
    }

    /**
     * @param value Unit of the metrics to return.
     */
    @JvmName("rrumsmejtdeqbwlh")
    public suspend fun unit(`value`: Output<String>) {
        this.unit = value
    }

    /**
     * @param value Structure that defines the CloudWatch metric to return, including the metric name, namespace, and dimensions.
     */
    @JvmName("odlauupuxtscqste")
    public suspend
    fun metric(`value`: PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedLoadMetricSpecificationMetricDataQueryMetricStatMetricArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metric = mapped
    }

    /**
     * @param argument Structure that defines the CloudWatch metric to return, including the metric name, namespace, and dimensions.
     */
    @JvmName("ehugqennxqsmqtan")
    public suspend
    fun metric(argument: suspend PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedLoadMetricSpecificationMetricDataQueryMetricStatMetricArgsBuilder.() -> Unit) {
        val toBeMapped =
            PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedLoadMetricSpecificationMetricDataQueryMetricStatMetricArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.metric = mapped
    }

    /**
     * @param value Statistic of the metrics to return.
     */
    @JvmName("apdkauoxhdhqmqit")
    public suspend fun stat(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stat = mapped
    }

    /**
     * @param value Unit of the metrics to return.
     */
    @JvmName("fdvenitftgumtwrp")
    public suspend fun unit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.unit = mapped
    }

    internal fun build():
        PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedLoadMetricSpecificationMetricDataQueryMetricStatArgs =
        PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedLoadMetricSpecificationMetricDataQueryMetricStatArgs(
            metric = metric ?: throw PulumiNullFieldException("metric"),
            stat = stat ?: throw PulumiNullFieldException("stat"),
            unit = unit,
        )
}
