@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin.inputs

import com.pulumi.aws.autoscaling.inputs.PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationMetricDataQueryMetricStatArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property metric Structure that defines the CloudWatch metric to return, including the metric name, namespace, and dimensions.
 * @property stat Statistic of the metrics to return.
 * @property unit Unit of the metrics to return.
 */
public data class
PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationMetricDataQueryMetricStatArgs(
    public val metric:
    Output<PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationMetricDataQueryMetricStatMetricArgs>,
    public val stat: Output<String>,
    public val unit: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.autoscaling.inputs.PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationMetricDataQueryMetricStatArgs> {
    override fun toJava():
        com.pulumi.aws.autoscaling.inputs.PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationMetricDataQueryMetricStatArgs =
        com.pulumi.aws.autoscaling.inputs.PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationMetricDataQueryMetricStatArgs.builder()
            .metric(metric.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .stat(stat.applyValue({ args0 -> args0 }))
            .unit(unit?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationMetricDataQueryMetricStatArgs].
 */
@PulumiTagMarker
public class
PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationMetricDataQueryMetricStatArgsBuilder
internal constructor() {
    private var metric:
        Output<PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationMetricDataQueryMetricStatMetricArgs>? =
        null

    private var stat: Output<String>? = null

    private var unit: Output<String>? = null

    /**
     * @param value Structure that defines the CloudWatch metric to return, including the metric name, namespace, and dimensions.
     */
    @JvmName("lngrdgfksrugljob")
    public suspend
    fun metric(`value`: Output<PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationMetricDataQueryMetricStatMetricArgs>) {
        this.metric = value
    }

    /**
     * @param value Statistic of the metrics to return.
     */
    @JvmName("mqkqlhmhbfavxhfj")
    public suspend fun stat(`value`: Output<String>) {
        this.stat = value
    }

    /**
     * @param value Unit of the metrics to return.
     */
    @JvmName("qttsyovjjdpxnwfh")
    public suspend fun unit(`value`: Output<String>) {
        this.unit = value
    }

    /**
     * @param value Structure that defines the CloudWatch metric to return, including the metric name, namespace, and dimensions.
     */
    @JvmName("iibhamssfolcgywg")
    public suspend
    fun metric(`value`: PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationMetricDataQueryMetricStatMetricArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metric = mapped
    }

    /**
     * @param argument Structure that defines the CloudWatch metric to return, including the metric name, namespace, and dimensions.
     */
    @JvmName("lrhuelxripbdaudh")
    public suspend
    fun metric(argument: suspend PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationMetricDataQueryMetricStatMetricArgsBuilder.() -> Unit) {
        val toBeMapped =
            PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationMetricDataQueryMetricStatMetricArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.metric = mapped
    }

    /**
     * @param value Statistic of the metrics to return.
     */
    @JvmName("kelvnqjfguwjoqqj")
    public suspend fun stat(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stat = mapped
    }

    /**
     * @param value Unit of the metrics to return.
     */
    @JvmName("geoyydbxsadvclub")
    public suspend fun unit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.unit = mapped
    }

    internal fun build():
        PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationMetricDataQueryMetricStatArgs =
        PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationMetricDataQueryMetricStatArgs(
            metric = metric ?: throw PulumiNullFieldException("metric"),
            stat = stat ?: throw PulumiNullFieldException("stat"),
            unit = unit,
        )
}
