@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin.inputs

import com.pulumi.aws.autoscaling.inputs.PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedScalingMetricSpecificationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property predefinedMetricType Describes a scaling metric for a predictive scaling policy. Valid values are `ASGAverageCPUUtilization`, `ASGAverageNetworkIn`, `ASGAverageNetworkOut`, or `ALBRequestCountPerTarget`.
 * @property resourceLabel Label that uniquely identifies a specific Application Load Balancer target group from which to determine the request count served by your Auto Scaling group. You create the resource label by appending the final portion of the load balancer ARN and the final portion of the target group ARN into a single value, separated by a forward slash (/). Refer to [PredefinedMetricSpecification](https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_PredefinedMetricSpecification.html) for more information.
 */
public data class
PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedScalingMetricSpecificationArgs(
    public val predefinedMetricType: Output<String>,
    public val resourceLabel: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.autoscaling.inputs.PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedScalingMetricSpecificationArgs> {
    override fun toJava():
        com.pulumi.aws.autoscaling.inputs.PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedScalingMetricSpecificationArgs =
        com.pulumi.aws.autoscaling.inputs.PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedScalingMetricSpecificationArgs.builder()
            .predefinedMetricType(predefinedMetricType.applyValue({ args0 -> args0 }))
            .resourceLabel(resourceLabel?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedScalingMetricSpecificationArgs].
 */
@PulumiTagMarker
public class
PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedScalingMetricSpecificationArgsBuilder
internal constructor() {
    private var predefinedMetricType: Output<String>? = null

    private var resourceLabel: Output<String>? = null

    /**
     * @param value Describes a scaling metric for a predictive scaling policy. Valid values are `ASGAverageCPUUtilization`, `ASGAverageNetworkIn`, `ASGAverageNetworkOut`, or `ALBRequestCountPerTarget`.
     */
    @JvmName("gfudcdkiuutkqhmy")
    public suspend fun predefinedMetricType(`value`: Output<String>) {
        this.predefinedMetricType = value
    }

    /**
     * @param value Label that uniquely identifies a specific Application Load Balancer target group from which to determine the request count served by your Auto Scaling group. You create the resource label by appending the final portion of the load balancer ARN and the final portion of the target group ARN into a single value, separated by a forward slash (/). Refer to [PredefinedMetricSpecification](https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_PredefinedMetricSpecification.html) for more information.
     */
    @JvmName("pelllimfgdrrjrde")
    public suspend fun resourceLabel(`value`: Output<String>) {
        this.resourceLabel = value
    }

    /**
     * @param value Describes a scaling metric for a predictive scaling policy. Valid values are `ASGAverageCPUUtilization`, `ASGAverageNetworkIn`, `ASGAverageNetworkOut`, or `ALBRequestCountPerTarget`.
     */
    @JvmName("uunlbnkvrfnqyrya")
    public suspend fun predefinedMetricType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.predefinedMetricType = mapped
    }

    /**
     * @param value Label that uniquely identifies a specific Application Load Balancer target group from which to determine the request count served by your Auto Scaling group. You create the resource label by appending the final portion of the load balancer ARN and the final portion of the target group ARN into a single value, separated by a forward slash (/). Refer to [PredefinedMetricSpecification](https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_PredefinedMetricSpecification.html) for more information.
     */
    @JvmName("qpyiresjqwytgcfp")
    public suspend fun resourceLabel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceLabel = mapped
    }

    internal fun build():
        PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedScalingMetricSpecificationArgs =
        PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedScalingMetricSpecificationArgs(
            predefinedMetricType = predefinedMetricType ?: throw
                PulumiNullFieldException("predefinedMetricType"),
            resourceLabel = resourceLabel,
        )
}
