@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin.inputs

import com.pulumi.aws.autoscaling.inputs.PolicyTargetTrackingConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Double
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property customizedMetricSpecification Customized metric. Conflicts with `predefined_metric_specification`.
 * @property disableScaleIn Whether scale in by the target tracking policy is disabled.
 * @property predefinedMetricSpecification Predefined metric. Conflicts with `customized_metric_specification`.
 * @property targetValue Target value for the metric.
 */
public data class PolicyTargetTrackingConfigurationArgs(
    public val customizedMetricSpecification:
    Output<PolicyTargetTrackingConfigurationCustomizedMetricSpecificationArgs>? = null,
    public val disableScaleIn: Output<Boolean>? = null,
    public val predefinedMetricSpecification:
    Output<PolicyTargetTrackingConfigurationPredefinedMetricSpecificationArgs>? = null,
    public val targetValue: Output<Double>,
) : ConvertibleToJava<com.pulumi.aws.autoscaling.inputs.PolicyTargetTrackingConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.autoscaling.inputs.PolicyTargetTrackingConfigurationArgs =
        com.pulumi.aws.autoscaling.inputs.PolicyTargetTrackingConfigurationArgs.builder()
            .customizedMetricSpecification(
                customizedMetricSpecification?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .disableScaleIn(disableScaleIn?.applyValue({ args0 -> args0 }))
            .predefinedMetricSpecification(
                predefinedMetricSpecification?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .targetValue(targetValue.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PolicyTargetTrackingConfigurationArgs].
 */
@PulumiTagMarker
public class PolicyTargetTrackingConfigurationArgsBuilder internal constructor() {
    private var customizedMetricSpecification:
        Output<PolicyTargetTrackingConfigurationCustomizedMetricSpecificationArgs>? = null

    private var disableScaleIn: Output<Boolean>? = null

    private var predefinedMetricSpecification:
        Output<PolicyTargetTrackingConfigurationPredefinedMetricSpecificationArgs>? = null

    private var targetValue: Output<Double>? = null

    /**
     * @param value Customized metric. Conflicts with `predefined_metric_specification`.
     */
    @JvmName("aulpdwqmagpddgrc")
    public suspend
    fun customizedMetricSpecification(`value`: Output<PolicyTargetTrackingConfigurationCustomizedMetricSpecificationArgs>) {
        this.customizedMetricSpecification = value
    }

    /**
     * @param value Whether scale in by the target tracking policy is disabled.
     */
    @JvmName("fjqloantclxvrpak")
    public suspend fun disableScaleIn(`value`: Output<Boolean>) {
        this.disableScaleIn = value
    }

    /**
     * @param value Predefined metric. Conflicts with `customized_metric_specification`.
     */
    @JvmName("rxehqqgtyxrmddkc")
    public suspend
    fun predefinedMetricSpecification(`value`: Output<PolicyTargetTrackingConfigurationPredefinedMetricSpecificationArgs>) {
        this.predefinedMetricSpecification = value
    }

    /**
     * @param value Target value for the metric.
     */
    @JvmName("cdpqgmbypcjmoaqs")
    public suspend fun targetValue(`value`: Output<Double>) {
        this.targetValue = value
    }

    /**
     * @param value Customized metric. Conflicts with `predefined_metric_specification`.
     */
    @JvmName("vkngwbfqvnciuwlk")
    public suspend
    fun customizedMetricSpecification(`value`: PolicyTargetTrackingConfigurationCustomizedMetricSpecificationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customizedMetricSpecification = mapped
    }

    /**
     * @param argument Customized metric. Conflicts with `predefined_metric_specification`.
     */
    @JvmName("qsyvpxvylvykpjld")
    public suspend
    fun customizedMetricSpecification(argument: suspend PolicyTargetTrackingConfigurationCustomizedMetricSpecificationArgsBuilder.() -> Unit) {
        val toBeMapped =
            PolicyTargetTrackingConfigurationCustomizedMetricSpecificationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.customizedMetricSpecification = mapped
    }

    /**
     * @param value Whether scale in by the target tracking policy is disabled.
     */
    @JvmName("lgepadkktjygqmgg")
    public suspend fun disableScaleIn(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableScaleIn = mapped
    }

    /**
     * @param value Predefined metric. Conflicts with `customized_metric_specification`.
     */
    @JvmName("hhvoaxogatiefjbc")
    public suspend
    fun predefinedMetricSpecification(`value`: PolicyTargetTrackingConfigurationPredefinedMetricSpecificationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.predefinedMetricSpecification = mapped
    }

    /**
     * @param argument Predefined metric. Conflicts with `customized_metric_specification`.
     */
    @JvmName("dmjldjkcbnfqyufy")
    public suspend
    fun predefinedMetricSpecification(argument: suspend PolicyTargetTrackingConfigurationPredefinedMetricSpecificationArgsBuilder.() -> Unit) {
        val toBeMapped =
            PolicyTargetTrackingConfigurationPredefinedMetricSpecificationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.predefinedMetricSpecification = mapped
    }

    /**
     * @param value Target value for the metric.
     */
    @JvmName("ledianrigrumcoft")
    public suspend fun targetValue(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetValue = mapped
    }

    internal fun build(): PolicyTargetTrackingConfigurationArgs =
        PolicyTargetTrackingConfigurationArgs(
            customizedMetricSpecification = customizedMetricSpecification,
            disableScaleIn = disableScaleIn,
            predefinedMetricSpecification = predefinedMetricSpecification,
            targetValue = targetValue ?: throw PulumiNullFieldException("targetValue"),
        )
}
