@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin.inputs

import com.pulumi.aws.autoscaling.inputs.PolicyTargetTrackingConfigurationCustomizedMetricSpecificationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property metricDimensions Dimensions of the metric.
 * @property metricName Name of the metric.
 * @property metrics Metrics to include, as a metric data query.
 * @property namespace Namespace of the metric.
 * @property statistic Statistic of the metric.
 * @property unit Unit of the metric.
 */
public data class PolicyTargetTrackingConfigurationCustomizedMetricSpecificationArgs(
    public val metricDimensions:
    Output<List<PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricDimensionArgs>>? =
        null,
    public val metricName: Output<String>? = null,
    public val metrics:
    Output<List<PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricArgs>>? =
        null,
    public val namespace: Output<String>? = null,
    public val statistic: Output<String>? = null,
    public val unit: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.autoscaling.inputs.PolicyTargetTrackingConfigurationCustomizedMetricSpecificationArgs> {
    override fun toJava():
        com.pulumi.aws.autoscaling.inputs.PolicyTargetTrackingConfigurationCustomizedMetricSpecificationArgs =
        com.pulumi.aws.autoscaling.inputs.PolicyTargetTrackingConfigurationCustomizedMetricSpecificationArgs.builder()
            .metricDimensions(
                metricDimensions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .metricName(metricName?.applyValue({ args0 -> args0 }))
            .metrics(
                metrics?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .namespace(namespace?.applyValue({ args0 -> args0 }))
            .statistic(statistic?.applyValue({ args0 -> args0 }))
            .unit(unit?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PolicyTargetTrackingConfigurationCustomizedMetricSpecificationArgs].
 */
@PulumiTagMarker
public class PolicyTargetTrackingConfigurationCustomizedMetricSpecificationArgsBuilder internal
constructor() {
    private var metricDimensions:
        Output<List<PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricDimensionArgs>>? =
        null

    private var metricName: Output<String>? = null

    private var metrics:
        Output<List<PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricArgs>>? = null

    private var namespace: Output<String>? = null

    private var statistic: Output<String>? = null

    private var unit: Output<String>? = null

    /**
     * @param value Dimensions of the metric.
     */
    @JvmName("oymhrgfamheogljn")
    public suspend
    fun metricDimensions(`value`: Output<List<PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricDimensionArgs>>) {
        this.metricDimensions = value
    }

    @JvmName("nnpofbxsfwwwcexa")
    public suspend fun metricDimensions(
        vararg
        values: Output<PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricDimensionArgs>,
    ) {
        this.metricDimensions = Output.all(values.asList())
    }

    /**
     * @param values Dimensions of the metric.
     */
    @JvmName("onoiuncgrdkhtjil")
    public suspend
    fun metricDimensions(values: List<Output<PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricDimensionArgs>>) {
        this.metricDimensions = Output.all(values)
    }

    /**
     * @param value Name of the metric.
     */
    @JvmName("hrftyytbdiwomcdg")
    public suspend fun metricName(`value`: Output<String>) {
        this.metricName = value
    }

    /**
     * @param value Metrics to include, as a metric data query.
     */
    @JvmName("tdjaeqrgpxcpntun")
    public suspend
    fun metrics(`value`: Output<List<PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricArgs>>) {
        this.metrics = value
    }

    @JvmName("agyiywtitqwrtiku")
    public suspend fun metrics(
        vararg
        values: Output<PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricArgs>,
    ) {
        this.metrics = Output.all(values.asList())
    }

    /**
     * @param values Metrics to include, as a metric data query.
     */
    @JvmName("accnyvvqqxlfdauk")
    public suspend
    fun metrics(values: List<Output<PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricArgs>>) {
        this.metrics = Output.all(values)
    }

    /**
     * @param value Namespace of the metric.
     */
    @JvmName("nladjrsvgobbponn")
    public suspend fun namespace(`value`: Output<String>) {
        this.namespace = value
    }

    /**
     * @param value Statistic of the metric.
     */
    @JvmName("fwalcsuyegrlvhvp")
    public suspend fun statistic(`value`: Output<String>) {
        this.statistic = value
    }

    /**
     * @param value Unit of the metric.
     */
    @JvmName("rssptkdcmfqgmwxk")
    public suspend fun unit(`value`: Output<String>) {
        this.unit = value
    }

    /**
     * @param value Dimensions of the metric.
     */
    @JvmName("jssmmjfsmewqxklc")
    public suspend
    fun metricDimensions(`value`: List<PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricDimensionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metricDimensions = mapped
    }

    /**
     * @param argument Dimensions of the metric.
     */
    @JvmName("jmoldxtrifvafnuj")
    public suspend
    fun metricDimensions(argument: List<suspend PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricDimensionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricDimensionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.metricDimensions = mapped
    }

    /**
     * @param argument Dimensions of the metric.
     */
    @JvmName("ernajyunyaatwboe")
    public suspend fun metricDimensions(
        vararg
        argument: suspend PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricDimensionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricDimensionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.metricDimensions = mapped
    }

    /**
     * @param argument Dimensions of the metric.
     */
    @JvmName("yxjmfqynybhnpmbd")
    public suspend
    fun metricDimensions(argument: suspend PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricDimensionArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricDimensionArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.metricDimensions = mapped
    }

    /**
     * @param values Dimensions of the metric.
     */
    @JvmName("kygnqcdihpgmkqys")
    public suspend fun metricDimensions(
        vararg
        values: PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricDimensionArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metricDimensions = mapped
    }

    /**
     * @param value Name of the metric.
     */
    @JvmName("jptdqqwewmikbajj")
    public suspend fun metricName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metricName = mapped
    }

    /**
     * @param value Metrics to include, as a metric data query.
     */
    @JvmName("dbtwahlaifaiuols")
    public suspend
    fun metrics(`value`: List<PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metrics = mapped
    }

    /**
     * @param argument Metrics to include, as a metric data query.
     */
    @JvmName("fktvskcnmkwxjngy")
    public suspend
    fun metrics(argument: List<suspend PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.metrics = mapped
    }

    /**
     * @param argument Metrics to include, as a metric data query.
     */
    @JvmName("qxivgtdjgfvlpots")
    public suspend fun metrics(
        vararg
        argument: suspend PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.metrics = mapped
    }

    /**
     * @param argument Metrics to include, as a metric data query.
     */
    @JvmName("smcgkvwinnbvrtur")
    public suspend
    fun metrics(argument: suspend PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.metrics = mapped
    }

    /**
     * @param values Metrics to include, as a metric data query.
     */
    @JvmName("nvsqlkmposaiexfc")
    public suspend fun metrics(
        vararg
        values: PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metrics = mapped
    }

    /**
     * @param value Namespace of the metric.
     */
    @JvmName("qfrodgmiopwlxqbw")
    public suspend fun namespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespace = mapped
    }

    /**
     * @param value Statistic of the metric.
     */
    @JvmName("fmjpjgmsjmderrcc")
    public suspend fun statistic(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.statistic = mapped
    }

    /**
     * @param value Unit of the metric.
     */
    @JvmName("xoqibveamqvsdste")
    public suspend fun unit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.unit = mapped
    }

    internal fun build(): PolicyTargetTrackingConfigurationCustomizedMetricSpecificationArgs =
        PolicyTargetTrackingConfigurationCustomizedMetricSpecificationArgs(
            metricDimensions = metricDimensions,
            metricName = metricName,
            metrics = metrics,
            namespace = namespace,
            statistic = statistic,
            unit = unit,
        )
}
