@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin.inputs

import com.pulumi.aws.autoscaling.inputs.PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricMetricStatMetricArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property dimensions Dimensions of the metric.
 * @property metricName Name of the metric.
 * @property namespace Namespace of the metric.
 */
public data class
PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricMetricStatMetricArgs(
    public val dimensions:
    Output<List<PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricMetricStatMetricDimensionArgs>>? =
        null,
    public val metricName: Output<String>,
    public val namespace: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.autoscaling.inputs.PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricMetricStatMetricArgs> {
    override fun toJava():
        com.pulumi.aws.autoscaling.inputs.PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricMetricStatMetricArgs =
        com.pulumi.aws.autoscaling.inputs.PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricMetricStatMetricArgs.builder()
            .dimensions(
                dimensions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .metricName(metricName.applyValue({ args0 -> args0 }))
            .namespace(namespace.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricMetricStatMetricArgs].
 */
@PulumiTagMarker
public class
PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricMetricStatMetricArgsBuilder
internal constructor() {
    private var dimensions:
        Output<List<PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricMetricStatMetricDimensionArgs>>? =
        null

    private var metricName: Output<String>? = null

    private var namespace: Output<String>? = null

    /**
     * @param value Dimensions of the metric.
     */
    @JvmName("cftdhmcesbmpidkk")
    public suspend
    fun dimensions(`value`: Output<List<PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricMetricStatMetricDimensionArgs>>) {
        this.dimensions = value
    }

    @JvmName("ppbgcignqdddfpuo")
    public suspend fun dimensions(
        vararg
        values: Output<PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricMetricStatMetricDimensionArgs>,
    ) {
        this.dimensions = Output.all(values.asList())
    }

    /**
     * @param values Dimensions of the metric.
     */
    @JvmName("oofpossbusofppkx")
    public suspend
    fun dimensions(values: List<Output<PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricMetricStatMetricDimensionArgs>>) {
        this.dimensions = Output.all(values)
    }

    /**
     * @param value Name of the metric.
     */
    @JvmName("hxnwoubyjccubyrf")
    public suspend fun metricName(`value`: Output<String>) {
        this.metricName = value
    }

    /**
     * @param value Namespace of the metric.
     */
    @JvmName("xaqwbiroxyrwarae")
    public suspend fun namespace(`value`: Output<String>) {
        this.namespace = value
    }

    /**
     * @param value Dimensions of the metric.
     */
    @JvmName("rgdcxlggxplbadgn")
    public suspend
    fun dimensions(`value`: List<PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricMetricStatMetricDimensionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dimensions = mapped
    }

    /**
     * @param argument Dimensions of the metric.
     */
    @JvmName("obyrsxcgvnuqnlhj")
    public suspend
    fun dimensions(argument: List<suspend PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricMetricStatMetricDimensionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricMetricStatMetricDimensionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dimensions = mapped
    }

    /**
     * @param argument Dimensions of the metric.
     */
    @JvmName("pycfvrfwommfiurc")
    public suspend fun dimensions(
        vararg
        argument: suspend PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricMetricStatMetricDimensionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricMetricStatMetricDimensionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dimensions = mapped
    }

    /**
     * @param argument Dimensions of the metric.
     */
    @JvmName("shipdrbamsiovfiv")
    public suspend
    fun dimensions(argument: suspend PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricMetricStatMetricDimensionArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricMetricStatMetricDimensionArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.dimensions = mapped
    }

    /**
     * @param values Dimensions of the metric.
     */
    @JvmName("crfkhtikxmjoutxe")
    public suspend fun dimensions(
        vararg
        values: PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricMetricStatMetricDimensionArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dimensions = mapped
    }

    /**
     * @param value Name of the metric.
     */
    @JvmName("cdthojtemjppclkn")
    public suspend fun metricName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metricName = mapped
    }

    /**
     * @param value Namespace of the metric.
     */
    @JvmName("trulwxebpuhrpaxs")
    public suspend fun namespace(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.namespace = mapped
    }

    internal fun build():
        PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricMetricStatMetricArgs =
        PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricMetricStatMetricArgs(
            dimensions = dimensions,
            metricName = metricName ?: throw PulumiNullFieldException("metricName"),
            namespace = namespace ?: throw PulumiNullFieldException("namespace"),
        )
}
