@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin.inputs

import com.pulumi.aws.autoscaling.inputs.TagTagArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property key Tag name.
 * @property propagateAtLaunch Whether to propagate the tags to instances launched by the ASG.
 * @property value Tag value.
 */
public data class TagTagArgs(
    public val key: Output<String>,
    public val propagateAtLaunch: Output<Boolean>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.autoscaling.inputs.TagTagArgs> {
    override fun toJava(): com.pulumi.aws.autoscaling.inputs.TagTagArgs =
        com.pulumi.aws.autoscaling.inputs.TagTagArgs.builder()
            .key(key.applyValue({ args0 -> args0 }))
            .propagateAtLaunch(propagateAtLaunch.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TagTagArgs].
 */
@PulumiTagMarker
public class TagTagArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var propagateAtLaunch: Output<Boolean>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Tag name.
     */
    @JvmName("dqvwkaxycmjpbvfj")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value Whether to propagate the tags to instances launched by the ASG.
     */
    @JvmName("dtxdidouiwcajqrs")
    public suspend fun propagateAtLaunch(`value`: Output<Boolean>) {
        this.propagateAtLaunch = value
    }

    /**
     * @param value Tag value.
     */
    @JvmName("tccikdtxyutwrnny")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Tag name.
     */
    @JvmName("okixhhebifkpslkk")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value Whether to propagate the tags to instances launched by the ASG.
     */
    @JvmName("oswfdomjuhrfxtmm")
    public suspend fun propagateAtLaunch(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.propagateAtLaunch = mapped
    }

    /**
     * @param value Tag value.
     */
    @JvmName("myrtdneliytltaxw")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): TagTagArgs = TagTagArgs(
        key = key ?: throw PulumiNullFieldException("key"),
        propagateAtLaunch = propagateAtLaunch ?: throw PulumiNullFieldException("propagateAtLaunch"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
