@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getAmiIds.
 * @property arns List of the Autoscaling Groups Arns in the current region.
 * @property filters
 * @property id The provider-assigned unique ID for this managed resource.
 * @property names List of the Autoscaling Groups in the current region.
 */
public data class GetAmiIdsResult(
    public val arns: List<String>,
    public val filters: List<GetAmiIdsFilter>? = null,
    public val id: String,
    public val names: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.autoscaling.outputs.GetAmiIdsResult):
            GetAmiIdsResult = GetAmiIdsResult(
            arns = javaType.arns().map({ args0 -> args0 }),
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.autoscaling.kotlin.outputs.GetAmiIdsFilter.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            names = javaType.names().map({ args0 -> args0 }),
        )
    }
}
