@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property id ID of the launch template.
 * @property name Specify the exact name of the desired autoscaling group.
 * @property version Template version.
 */
public data class GetGroupLaunchTemplate(
    public val id: String,
    public val name: String,
    public val version: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.autoscaling.outputs.GetGroupLaunchTemplate):
            GetGroupLaunchTemplate = GetGroupLaunchTemplate(
            id = javaType.id(),
            name = javaType.name(),
            version = javaType.version(),
        )
    }
}
