@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property instancesDistributions List of instances distribution objects.
 * @property launchTemplates List of launch templates along with the overrides.
 */
public data class GetGroupMixedInstancesPolicy(
    public val instancesDistributions: List<GetGroupMixedInstancesPolicyInstancesDistribution>,
    public val launchTemplates: List<GetGroupMixedInstancesPolicyLaunchTemplate>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.autoscaling.outputs.GetGroupMixedInstancesPolicy):
            GetGroupMixedInstancesPolicy = GetGroupMixedInstancesPolicy(
            instancesDistributions = javaType.instancesDistributions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.autoscaling.kotlin.outputs.GetGroupMixedInstancesPolicyInstancesDistribution.Companion.toKotlin(args0)
                })
            }),
            launchTemplates = javaType.launchTemplates().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.autoscaling.kotlin.outputs.GetGroupMixedInstancesPolicyLaunchTemplate.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
