@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property identifier Identifies the traffic source. For Application Load Balancers, Gateway Load Balancers, Network Load Balancers, and VPC Lattice, this will be the Amazon Resource Name (ARN) for a target group in this account and Region. For Classic Load Balancers, this will be the name of the Classic Load Balancer in this account and Region.
 * @property type Traffic source type.
 */
public data class GetGroupTrafficSource(
    public val identifier: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.autoscaling.outputs.GetGroupTrafficSource):
            GetGroupTrafficSource = GetGroupTrafficSource(
            identifier = javaType.identifier(),
            type = javaType.type(),
        )
    }
}
