@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property autoRollback Automatically rollback if instance refresh fails. Defaults to `false`. This option may only be set to `true` when specifying a `launch_template` or `mixed_instances_policy`.
 * @property checkpointDelay Number of seconds to wait after a checkpoint. Defaults to `3600`.
 * @property checkpointPercentages List of percentages for each checkpoint. Values must be unique and in ascending order. To replace all instances, the final number must be `100`.
 * @property instanceWarmup Number of seconds until a newly launched instance is configured and ready to use. Default behavior is to use the Auto Scaling Group's health check grace period.
 * @property minHealthyPercentage Specifies the lower limit on the number of instances that must be in the InService state with a healthy status during an instance replacement activity.
 * @property scaleInProtectedInstances Behavior when encountering instances protected from scale in are found. Available behaviors are `Refresh`, `Ignore`, and `Wait`. Default is `Ignore`.
 * @property skipMatching Replace instances that already have your desired configuration. Defaults to `false`.
 * @property standbyInstances Behavior when encountering instances in the `Standby` state in are found. Available behaviors are `Terminate`, `Ignore`, and `Wait`. Default is `Ignore`.
 */
public data class GroupInstanceRefreshPreferences(
    public val autoRollback: Boolean? = null,
    public val checkpointDelay: String? = null,
    public val checkpointPercentages: List<Int>? = null,
    public val instanceWarmup: String? = null,
    public val minHealthyPercentage: Int? = null,
    public val scaleInProtectedInstances: String? = null,
    public val skipMatching: Boolean? = null,
    public val standbyInstances: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.autoscaling.outputs.GroupInstanceRefreshPreferences):
            GroupInstanceRefreshPreferences = GroupInstanceRefreshPreferences(
            autoRollback = javaType.autoRollback().map({ args0 -> args0 }).orElse(null),
            checkpointDelay = javaType.checkpointDelay().map({ args0 -> args0 }).orElse(null),
            checkpointPercentages = javaType.checkpointPercentages().map({ args0 -> args0 }),
            instanceWarmup = javaType.instanceWarmup().map({ args0 -> args0 }).orElse(null),
            minHealthyPercentage = javaType.minHealthyPercentage().map({ args0 -> args0 }).orElse(null),
            scaleInProtectedInstances = javaType.scaleInProtectedInstances().map({ args0 ->
                args0
            }).orElse(null),
            skipMatching = javaType.skipMatching().map({ args0 -> args0 }).orElse(null),
            standbyInstances = javaType.standbyInstances().map({ args0 -> args0 }).orElse(null),
        )
    }
}
