@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property instanceRequirements Override the instance type in the Launch Template with instance types that satisfy the requirements.
 * @property instanceType Override the instance type in the Launch Template.
 * @property launchTemplateSpecification Override the instance launch template specification in the Launch Template.
 * @property weightedCapacity Number of capacity units, which gives the instance type a proportional weight to other instance types.
 */
public data class GroupMixedInstancesPolicyLaunchTemplateOverride(
    public val instanceRequirements:
    GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirements? = null,
    public val instanceType: String? = null,
    public val launchTemplateSpecification:
    GroupMixedInstancesPolicyLaunchTemplateOverrideLaunchTemplateSpecification? = null,
    public val weightedCapacity: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.autoscaling.outputs.GroupMixedInstancesPolicyLaunchTemplateOverride):
            GroupMixedInstancesPolicyLaunchTemplateOverride =
            GroupMixedInstancesPolicyLaunchTemplateOverride(
                instanceRequirements = javaType.instanceRequirements().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.autoscaling.kotlin.outputs.GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirements.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                instanceType = javaType.instanceType().map({ args0 -> args0 }).orElse(null),
                launchTemplateSpecification = javaType.launchTemplateSpecification().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.autoscaling.kotlin.outputs.GroupMixedInstancesPolicyLaunchTemplateOverrideLaunchTemplateSpecification.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                weightedCapacity = javaType.weightedCapacity().map({ args0 -> args0 }).orElse(null),
            )
    }
}
