@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property launchTemplateId ID of the launch template. Conflicts with `launch_template_name`.
 * @property launchTemplateName Name of the launch template. Conflicts with `launch_template_id`.
 * @property version Template version. Can be version number, `$Latest`, or `$Default`. (Default: `$Default`).
 */
public data class GroupMixedInstancesPolicyLaunchTemplateOverrideLaunchTemplateSpecification(
    public val launchTemplateId: String? = null,
    public val launchTemplateName: String? = null,
    public val version: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.autoscaling.outputs.GroupMixedInstancesPolicyLaunchTemplateOverrideLaunchTemplateSpecification):
            GroupMixedInstancesPolicyLaunchTemplateOverrideLaunchTemplateSpecification =
            GroupMixedInstancesPolicyLaunchTemplateOverrideLaunchTemplateSpecification(
                launchTemplateId = javaType.launchTemplateId().map({ args0 -> args0 }).orElse(null),
                launchTemplateName = javaType.launchTemplateName().map({ args0 -> args0 }).orElse(null),
                version = javaType.version().map({ args0 -> args0 }).orElse(null),
            )
    }
}
