@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property instanceReusePolicy Whether instances in the Auto Scaling group can be returned to the warm pool on scale in. The default is to terminate instances in the Auto Scaling group when the group scales in.
 * @property maxGroupPreparedCapacity Total maximum number of instances that are allowed to be in the warm pool or in any state except Terminated for the Auto Scaling group.
 * @property minSize Minimum number of instances to maintain in the warm pool. This helps you to ensure that there is always a certain number of warmed instances available to handle traffic spikes. Defaults to 0 if not specified.
 * @property poolState Sets the instance state to transition to after the lifecycle hooks finish. Valid values are: Stopped (default), Running or Hibernated.
 */
public data class GroupWarmPool(
    public val instanceReusePolicy: GroupWarmPoolInstanceReusePolicy? = null,
    public val maxGroupPreparedCapacity: Int? = null,
    public val minSize: Int? = null,
    public val poolState: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.autoscaling.outputs.GroupWarmPool): GroupWarmPool =
            GroupWarmPool(
                instanceReusePolicy = javaType.instanceReusePolicy().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.autoscaling.kotlin.outputs.GroupWarmPoolInstanceReusePolicy.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                maxGroupPreparedCapacity = javaType.maxGroupPreparedCapacity().map({ args0 -> args0 }).orElse(null),
                minSize = javaType.minSize().map({ args0 -> args0 }).orElse(null),
                poolState = javaType.poolState().map({ args0 -> args0 }).orElse(null),
            )
    }
}
