@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property expression Math expression used on the returned metric. You must specify either `expression` or `metric_stat`, but not both.
 * @property id Short name for the metric used in predictive scaling policy.
 * @property label Human-readable label for this metric or expression.
 * @property metricStat Structure that defines CloudWatch metric to be used in predictive scaling policy. You must specify either `expression` or `metric_stat`, but not both.
 * @property returnData Boolean that indicates whether to return the timestamps and raw data values of this metric, the default is true
 */
public data class
PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedCapacityMetricSpecificationMetricDataQuery(
    public val expression: String? = null,
    public val id: String,
    public val label: String? = null,
    public val metricStat:
    PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedCapacityMetricSpecificationMetricDataQueryMetricStat? =
        null,
    public val returnData: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.autoscaling.outputs.PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedCapacityMetricSpecificationMetricDataQuery):
            PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedCapacityMetricSpecificationMetricDataQuery =
            PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedCapacityMetricSpecificationMetricDataQuery(
                expression = javaType.expression().map({ args0 -> args0 }).orElse(null),
                id = javaType.id(),
                label = javaType.label().map({ args0 -> args0 }).orElse(null),
                metricStat = javaType.metricStat().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.autoscaling.kotlin.outputs.PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedCapacityMetricSpecificationMetricDataQueryMetricStat.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                returnData = javaType.returnData().map({ args0 -> args0 }).orElse(null),
            )
    }
}
