@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property metricIntervalLowerBound Lower bound for the
 * difference between the alarm threshold and the CloudWatch metric.
 * Without a value, AWS will treat this bound as negative infinity.
 * @property metricIntervalUpperBound Upper bound for the
 * difference between the alarm threshold and the CloudWatch metric.
 * Without a value, AWS will treat this bound as positive infinity. The upper bound
 * must be greater than the lower bound.
 * Notice the bounds are **relative** to the alarm threshold, meaning that the starting point is not 0%, but the alarm threshold. Check the official [docs](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html#as-scaling-steps) for a detailed example.
 * The following arguments are only available to "TargetTrackingScaling" type policies:
 * @property scalingAdjustment Number of members by which to
 * scale, when the adjustment bounds are breached. A positive value scales
 * up. A negative value scales down.
 */
public data class PolicyStepAdjustment(
    public val metricIntervalLowerBound: String? = null,
    public val metricIntervalUpperBound: String? = null,
    public val scalingAdjustment: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.autoscaling.outputs.PolicyStepAdjustment):
            PolicyStepAdjustment = PolicyStepAdjustment(
            metricIntervalLowerBound = javaType.metricIntervalLowerBound().map({ args0 -> args0 }).orElse(null),
            metricIntervalUpperBound = javaType.metricIntervalUpperBound().map({ args0 -> args0 }).orElse(null),
            scalingAdjustment = javaType.scalingAdjustment(),
        )
    }
}
