@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property metricDimensions Dimensions of the metric.
 * @property metricName Name of the metric.
 * @property metrics Metrics to include, as a metric data query.
 * @property namespace Namespace of the metric.
 * @property statistic Statistic of the metric.
 * @property unit Unit of the metric.
 */
public data class PolicyTargetTrackingConfigurationCustomizedMetricSpecification(
    public val metricDimensions:
    List<PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricDimension>? = null,
    public val metricName: String? = null,
    public val metrics: List<PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetric>? =
        null,
    public val namespace: String? = null,
    public val statistic: String? = null,
    public val unit: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.autoscaling.outputs.PolicyTargetTrackingConfigurationCustomizedMetricSpecification):
            PolicyTargetTrackingConfigurationCustomizedMetricSpecification =
            PolicyTargetTrackingConfigurationCustomizedMetricSpecification(
                metricDimensions = javaType.metricDimensions().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.autoscaling.kotlin.outputs.PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricDimension.Companion.toKotlin(args0)
                    })
                }),
                metricName = javaType.metricName().map({ args0 -> args0 }).orElse(null),
                metrics = javaType.metrics().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.autoscaling.kotlin.outputs.PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetric.Companion.toKotlin(args0)
                    })
                }),
                namespace = javaType.namespace().map({ args0 -> args0 }).orElse(null),
                statistic = javaType.statistic().map({ args0 -> args0 }).orElse(null),
                unit = javaType.unit().map({ args0 -> args0 }).orElse(null),
            )
    }
}
