@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscalingplans.kotlin

import com.pulumi.aws.autoscalingplans.kotlin.outputs.ScalingPlanApplicationSource
import com.pulumi.aws.autoscalingplans.kotlin.outputs.ScalingPlanScalingInstruction
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.autoscalingplans.kotlin.outputs.ScalingPlanApplicationSource.Companion.toKotlin as scalingPlanApplicationSourceToKotlin
import com.pulumi.aws.autoscalingplans.kotlin.outputs.ScalingPlanScalingInstruction.Companion.toKotlin as scalingPlanScalingInstructionToKotlin

/**
 * Builder for [ScalingPlan].
 */
@PulumiTagMarker
public class ScalingPlanResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ScalingPlanArgs = ScalingPlanArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ScalingPlanArgsBuilder.() -> Unit) {
        val builder = ScalingPlanArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ScalingPlan {
        val builtJavaResource = com.pulumi.aws.autoscalingplans.ScalingPlan(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ScalingPlan(builtJavaResource)
    }
}

/**
 * Manages an AWS Auto Scaling scaling plan.
 * More information can be found in the [AWS Auto Scaling User Guide](https://docs.aws.amazon.com/autoscaling/plans/userguide/what-is-aws-auto-scaling.html).
 * > **NOTE:** The AWS Auto Scaling service uses an AWS IAM service-linked role to manage predictive scaling of Amazon EC2 Auto Scaling groups. The service attempts to automatically create this role the first time a scaling plan with predictive scaling enabled is created.
 * An `aws.iam.ServiceLinkedRole` resource can be used to manually manage this role.
 * See the [AWS documentation](https://docs.aws.amazon.com/autoscaling/plans/userguide/aws-auto-scaling-service-linked-roles.html#create-service-linked-role-manual) for more details.
 * {{% examples %}}
 * ## Example Usage
 * {{% /examples %}}
 * ## Import
 * Using `pulumi import`, import Auto Scaling scaling plans using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:autoscalingplans/scalingPlan:ScalingPlan example MyScale1
 * ```
 *
 */
public class ScalingPlan internal constructor(
    override val javaResource: com.pulumi.aws.autoscalingplans.ScalingPlan,
) : KotlinCustomResource(javaResource, ScalingPlanMapper) {
    /**
     * CloudFormation stack or set of tags. You can create one scaling plan per application source.
     */
    public val applicationSource: Output<ScalingPlanApplicationSource>
        get() = javaResource.applicationSource().applyValue({ args0 ->
            args0.let({ args0 ->
                scalingPlanApplicationSourceToKotlin(args0)
            })
        })

    /**
     * Name of the scaling plan. Names cannot contain vertical bars, colons, or forward slashes.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Scaling instructions. More details can be found in the [AWS Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_ScalingInstruction.html).
     */
    public val scalingInstructions: Output<List<ScalingPlanScalingInstruction>>
        get() = javaResource.scalingInstructions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> scalingPlanScalingInstructionToKotlin(args0) })
            })
        })

    /**
     * The version number of the scaling plan. This value is always 1.
     */
    public val scalingPlanVersion: Output<Int>
        get() = javaResource.scalingPlanVersion().applyValue({ args0 -> args0 })
}

public object ScalingPlanMapper : ResourceMapper<ScalingPlan> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.autoscalingplans.ScalingPlan::class == javaResource::class

    override fun map(javaResource: Resource): ScalingPlan = ScalingPlan(
        javaResource as
            com.pulumi.aws.autoscalingplans.ScalingPlan,
    )
}

/**
 * @see [ScalingPlan].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ScalingPlan].
 */
public suspend fun scalingPlan(name: String, block: suspend ScalingPlanResourceBuilder.() -> Unit):
    ScalingPlan {
    val builder = ScalingPlanResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ScalingPlan].
 * @param name The _unique_ name of the resulting resource.
 */
public fun scalingPlan(name: String): ScalingPlan {
    val builder = ScalingPlanResourceBuilder()
    builder.name(name)
    return builder.build()
}
