@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscalingplans.kotlin.inputs

import com.pulumi.aws.autoscalingplans.inputs.ScalingPlanScalingInstructionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property customizedLoadMetricSpecification Customized load metric to use for predictive scaling. You must specify either `customized_load_metric_specification` or `predefined_load_metric_specification` when configuring predictive scaling.
 * More details can be found in the [AWS Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_CustomizedLoadMetricSpecification.html).
 * @property disableDynamicScaling Boolean controlling whether dynamic scaling by AWS Auto Scaling is disabled. Defaults to `false`.
 * @property maxCapacity Maximum capacity of the resource. The exception to this upper limit is if you specify a non-default setting for `predictive_scaling_max_capacity_behavior`.
 * @property minCapacity Minimum capacity of the resource.
 * @property predefinedLoadMetricSpecification Predefined load metric to use for predictive scaling. You must specify either `predefined_load_metric_specification` or `customized_load_metric_specification` when configuring predictive scaling.
 * More details can be found in the [AWS Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_PredefinedLoadMetricSpecification.html).
 * @property predictiveScalingMaxCapacityBehavior Defines the behavior that should be applied if the forecast capacity approaches or exceeds the maximum capacity specified for the resource.
 * Valid values: `SetForecastCapacityToMaxCapacity`, `SetMaxCapacityAboveForecastCapacity`, `SetMaxCapacityToForecastCapacity`.
 * @property predictiveScalingMaxCapacityBuffer Size of the capacity buffer to use when the forecast capacity is close to or exceeds the maximum capacity.
 * @property predictiveScalingMode Predictive scaling mode. Valid values: `ForecastAndScale`, `ForecastOnly`.
 * @property resourceId ID of the resource. This string consists of the resource type and unique identifier.
 * @property scalableDimension Scalable dimension associated with the resource. Valid values: `autoscaling:autoScalingGroup:DesiredCapacity`, `dynamodb:index:ReadCapacityUnits`, `dynamodb:index:WriteCapacityUnits`, `dynamodb:table:ReadCapacityUnits`, `dynamodb:table:WriteCapacityUnits`, `ecs:service:DesiredCount`, `ec2:spot-fleet-request:TargetCapacity`, `rds:cluster:ReadReplicaCount`.
 * @property scalingPolicyUpdateBehavior Controls whether a resource's externally created scaling policies are kept or replaced. Valid values: `KeepExternalPolicies`, `ReplaceExternalPolicies`. Defaults to `KeepExternalPolicies`.
 * @property scheduledActionBufferTime Amount of time, in seconds, to buffer the run time of scheduled scaling actions when scaling out.
 * @property serviceNamespace Namespace of the AWS service. Valid values: `autoscaling`, `dynamodb`, `ecs`, `ec2`, `rds`.
 * @property targetTrackingConfigurations Structure that defines new target tracking configurations. Each of these structures includes a specific scaling metric and a target value for the metric, along with various parameters to use with dynamic scaling.
 * More details can be found in the [AWS Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_TargetTrackingConfiguration.html).
 */
public data class ScalingPlanScalingInstructionArgs(
    public val customizedLoadMetricSpecification:
    Output<ScalingPlanScalingInstructionCustomizedLoadMetricSpecificationArgs>? = null,
    public val disableDynamicScaling: Output<Boolean>? = null,
    public val maxCapacity: Output<Int>,
    public val minCapacity: Output<Int>,
    public val predefinedLoadMetricSpecification:
    Output<ScalingPlanScalingInstructionPredefinedLoadMetricSpecificationArgs>? = null,
    public val predictiveScalingMaxCapacityBehavior: Output<String>? = null,
    public val predictiveScalingMaxCapacityBuffer: Output<Int>? = null,
    public val predictiveScalingMode: Output<String>? = null,
    public val resourceId: Output<String>,
    public val scalableDimension: Output<String>,
    public val scalingPolicyUpdateBehavior: Output<String>? = null,
    public val scheduledActionBufferTime: Output<Int>? = null,
    public val serviceNamespace: Output<String>,
    public val targetTrackingConfigurations:
    Output<List<ScalingPlanScalingInstructionTargetTrackingConfigurationArgs>>,
) : ConvertibleToJava<com.pulumi.aws.autoscalingplans.inputs.ScalingPlanScalingInstructionArgs> {
    override fun toJava(): com.pulumi.aws.autoscalingplans.inputs.ScalingPlanScalingInstructionArgs =
        com.pulumi.aws.autoscalingplans.inputs.ScalingPlanScalingInstructionArgs.builder()
            .customizedLoadMetricSpecification(
                customizedLoadMetricSpecification?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .disableDynamicScaling(disableDynamicScaling?.applyValue({ args0 -> args0 }))
            .maxCapacity(maxCapacity.applyValue({ args0 -> args0 }))
            .minCapacity(minCapacity.applyValue({ args0 -> args0 }))
            .predefinedLoadMetricSpecification(
                predefinedLoadMetricSpecification?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .predictiveScalingMaxCapacityBehavior(
                predictiveScalingMaxCapacityBehavior?.applyValue({ args0 ->
                    args0
                }),
            )
            .predictiveScalingMaxCapacityBuffer(
                predictiveScalingMaxCapacityBuffer?.applyValue({ args0 ->
                    args0
                }),
            )
            .predictiveScalingMode(predictiveScalingMode?.applyValue({ args0 -> args0 }))
            .resourceId(resourceId.applyValue({ args0 -> args0 }))
            .scalableDimension(scalableDimension.applyValue({ args0 -> args0 }))
            .scalingPolicyUpdateBehavior(scalingPolicyUpdateBehavior?.applyValue({ args0 -> args0 }))
            .scheduledActionBufferTime(scheduledActionBufferTime?.applyValue({ args0 -> args0 }))
            .serviceNamespace(serviceNamespace.applyValue({ args0 -> args0 }))
            .targetTrackingConfigurations(
                targetTrackingConfigurations.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            ).build()
}

/**
 * Builder for [ScalingPlanScalingInstructionArgs].
 */
@PulumiTagMarker
public class ScalingPlanScalingInstructionArgsBuilder internal constructor() {
    private var customizedLoadMetricSpecification:
        Output<ScalingPlanScalingInstructionCustomizedLoadMetricSpecificationArgs>? = null

    private var disableDynamicScaling: Output<Boolean>? = null

    private var maxCapacity: Output<Int>? = null

    private var minCapacity: Output<Int>? = null

    private var predefinedLoadMetricSpecification:
        Output<ScalingPlanScalingInstructionPredefinedLoadMetricSpecificationArgs>? = null

    private var predictiveScalingMaxCapacityBehavior: Output<String>? = null

    private var predictiveScalingMaxCapacityBuffer: Output<Int>? = null

    private var predictiveScalingMode: Output<String>? = null

    private var resourceId: Output<String>? = null

    private var scalableDimension: Output<String>? = null

    private var scalingPolicyUpdateBehavior: Output<String>? = null

    private var scheduledActionBufferTime: Output<Int>? = null

    private var serviceNamespace: Output<String>? = null

    private var targetTrackingConfigurations:
        Output<List<ScalingPlanScalingInstructionTargetTrackingConfigurationArgs>>? = null

    /**
     * @param value Customized load metric to use for predictive scaling. You must specify either `customized_load_metric_specification` or `predefined_load_metric_specification` when configuring predictive scaling.
     * More details can be found in the [AWS Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_CustomizedLoadMetricSpecification.html).
     */
    @JvmName("bndsuwekiblqrjhy")
    public suspend
    fun customizedLoadMetricSpecification(`value`: Output<ScalingPlanScalingInstructionCustomizedLoadMetricSpecificationArgs>) {
        this.customizedLoadMetricSpecification = value
    }

    /**
     * @param value Boolean controlling whether dynamic scaling by AWS Auto Scaling is disabled. Defaults to `false`.
     */
    @JvmName("dfiiowtcdguojaep")
    public suspend fun disableDynamicScaling(`value`: Output<Boolean>) {
        this.disableDynamicScaling = value
    }

    /**
     * @param value Maximum capacity of the resource. The exception to this upper limit is if you specify a non-default setting for `predictive_scaling_max_capacity_behavior`.
     */
    @JvmName("xkqvuyblbnsndjoh")
    public suspend fun maxCapacity(`value`: Output<Int>) {
        this.maxCapacity = value
    }

    /**
     * @param value Minimum capacity of the resource.
     */
    @JvmName("tnkkqxnmsaeyqsrf")
    public suspend fun minCapacity(`value`: Output<Int>) {
        this.minCapacity = value
    }

    /**
     * @param value Predefined load metric to use for predictive scaling. You must specify either `predefined_load_metric_specification` or `customized_load_metric_specification` when configuring predictive scaling.
     * More details can be found in the [AWS Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_PredefinedLoadMetricSpecification.html).
     */
    @JvmName("qhtxwrvsrygvgebw")
    public suspend
    fun predefinedLoadMetricSpecification(`value`: Output<ScalingPlanScalingInstructionPredefinedLoadMetricSpecificationArgs>) {
        this.predefinedLoadMetricSpecification = value
    }

    /**
     * @param value Defines the behavior that should be applied if the forecast capacity approaches or exceeds the maximum capacity specified for the resource.
     * Valid values: `SetForecastCapacityToMaxCapacity`, `SetMaxCapacityAboveForecastCapacity`, `SetMaxCapacityToForecastCapacity`.
     */
    @JvmName("ccxeaxbvfxirtxek")
    public suspend fun predictiveScalingMaxCapacityBehavior(`value`: Output<String>) {
        this.predictiveScalingMaxCapacityBehavior = value
    }

    /**
     * @param value Size of the capacity buffer to use when the forecast capacity is close to or exceeds the maximum capacity.
     */
    @JvmName("nmqkmbnbwyujkmhr")
    public suspend fun predictiveScalingMaxCapacityBuffer(`value`: Output<Int>) {
        this.predictiveScalingMaxCapacityBuffer = value
    }

    /**
     * @param value Predictive scaling mode. Valid values: `ForecastAndScale`, `ForecastOnly`.
     */
    @JvmName("wdhxmgycunokhttc")
    public suspend fun predictiveScalingMode(`value`: Output<String>) {
        this.predictiveScalingMode = value
    }

    /**
     * @param value ID of the resource. This string consists of the resource type and unique identifier.
     */
    @JvmName("assapudmgowqytax")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value Scalable dimension associated with the resource. Valid values: `autoscaling:autoScalingGroup:DesiredCapacity`, `dynamodb:index:ReadCapacityUnits`, `dynamodb:index:WriteCapacityUnits`, `dynamodb:table:ReadCapacityUnits`, `dynamodb:table:WriteCapacityUnits`, `ecs:service:DesiredCount`, `ec2:spot-fleet-request:TargetCapacity`, `rds:cluster:ReadReplicaCount`.
     */
    @JvmName("dvwbcvxfixjoreev")
    public suspend fun scalableDimension(`value`: Output<String>) {
        this.scalableDimension = value
    }

    /**
     * @param value Controls whether a resource's externally created scaling policies are kept or replaced. Valid values: `KeepExternalPolicies`, `ReplaceExternalPolicies`. Defaults to `KeepExternalPolicies`.
     */
    @JvmName("wkwxpoydpyimncex")
    public suspend fun scalingPolicyUpdateBehavior(`value`: Output<String>) {
        this.scalingPolicyUpdateBehavior = value
    }

    /**
     * @param value Amount of time, in seconds, to buffer the run time of scheduled scaling actions when scaling out.
     */
    @JvmName("mytewdbgjslciffn")
    public suspend fun scheduledActionBufferTime(`value`: Output<Int>) {
        this.scheduledActionBufferTime = value
    }

    /**
     * @param value Namespace of the AWS service. Valid values: `autoscaling`, `dynamodb`, `ecs`, `ec2`, `rds`.
     */
    @JvmName("psogwyddtydndfvl")
    public suspend fun serviceNamespace(`value`: Output<String>) {
        this.serviceNamespace = value
    }

    /**
     * @param value Structure that defines new target tracking configurations. Each of these structures includes a specific scaling metric and a target value for the metric, along with various parameters to use with dynamic scaling.
     * More details can be found in the [AWS Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_TargetTrackingConfiguration.html).
     */
    @JvmName("ulvnajwqibrgmifd")
    public suspend
    fun targetTrackingConfigurations(`value`: Output<List<ScalingPlanScalingInstructionTargetTrackingConfigurationArgs>>) {
        this.targetTrackingConfigurations = value
    }

    @JvmName("chatphdikcuvbovg")
    public suspend fun targetTrackingConfigurations(
        vararg
        values: Output<ScalingPlanScalingInstructionTargetTrackingConfigurationArgs>,
    ) {
        this.targetTrackingConfigurations = Output.all(values.asList())
    }

    /**
     * @param values Structure that defines new target tracking configurations. Each of these structures includes a specific scaling metric and a target value for the metric, along with various parameters to use with dynamic scaling.
     * More details can be found in the [AWS Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_TargetTrackingConfiguration.html).
     */
    @JvmName("lrijcjjoxasjfkob")
    public suspend
    fun targetTrackingConfigurations(values: List<Output<ScalingPlanScalingInstructionTargetTrackingConfigurationArgs>>) {
        this.targetTrackingConfigurations = Output.all(values)
    }

    /**
     * @param value Customized load metric to use for predictive scaling. You must specify either `customized_load_metric_specification` or `predefined_load_metric_specification` when configuring predictive scaling.
     * More details can be found in the [AWS Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_CustomizedLoadMetricSpecification.html).
     */
    @JvmName("lbhjekouktycrfue")
    public suspend
    fun customizedLoadMetricSpecification(`value`: ScalingPlanScalingInstructionCustomizedLoadMetricSpecificationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customizedLoadMetricSpecification = mapped
    }

    /**
     * @param argument Customized load metric to use for predictive scaling. You must specify either `customized_load_metric_specification` or `predefined_load_metric_specification` when configuring predictive scaling.
     * More details can be found in the [AWS Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_CustomizedLoadMetricSpecification.html).
     */
    @JvmName("bkkqcrhbomvhqcqk")
    public suspend
    fun customizedLoadMetricSpecification(argument: suspend ScalingPlanScalingInstructionCustomizedLoadMetricSpecificationArgsBuilder.() -> Unit) {
        val toBeMapped =
            ScalingPlanScalingInstructionCustomizedLoadMetricSpecificationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.customizedLoadMetricSpecification = mapped
    }

    /**
     * @param value Boolean controlling whether dynamic scaling by AWS Auto Scaling is disabled. Defaults to `false`.
     */
    @JvmName("vwemdwmpkebajuef")
    public suspend fun disableDynamicScaling(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableDynamicScaling = mapped
    }

    /**
     * @param value Maximum capacity of the resource. The exception to this upper limit is if you specify a non-default setting for `predictive_scaling_max_capacity_behavior`.
     */
    @JvmName("brognjmkcticfbqw")
    public suspend fun maxCapacity(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maxCapacity = mapped
    }

    /**
     * @param value Minimum capacity of the resource.
     */
    @JvmName("mppcxqhklchygjpf")
    public suspend fun minCapacity(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.minCapacity = mapped
    }

    /**
     * @param value Predefined load metric to use for predictive scaling. You must specify either `predefined_load_metric_specification` or `customized_load_metric_specification` when configuring predictive scaling.
     * More details can be found in the [AWS Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_PredefinedLoadMetricSpecification.html).
     */
    @JvmName("odjqvwkojutkjcmw")
    public suspend
    fun predefinedLoadMetricSpecification(`value`: ScalingPlanScalingInstructionPredefinedLoadMetricSpecificationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.predefinedLoadMetricSpecification = mapped
    }

    /**
     * @param argument Predefined load metric to use for predictive scaling. You must specify either `predefined_load_metric_specification` or `customized_load_metric_specification` when configuring predictive scaling.
     * More details can be found in the [AWS Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_PredefinedLoadMetricSpecification.html).
     */
    @JvmName("wjbcfcxocmyuivxr")
    public suspend
    fun predefinedLoadMetricSpecification(argument: suspend ScalingPlanScalingInstructionPredefinedLoadMetricSpecificationArgsBuilder.() -> Unit) {
        val toBeMapped =
            ScalingPlanScalingInstructionPredefinedLoadMetricSpecificationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.predefinedLoadMetricSpecification = mapped
    }

    /**
     * @param value Defines the behavior that should be applied if the forecast capacity approaches or exceeds the maximum capacity specified for the resource.
     * Valid values: `SetForecastCapacityToMaxCapacity`, `SetMaxCapacityAboveForecastCapacity`, `SetMaxCapacityToForecastCapacity`.
     */
    @JvmName("xalepvekbjcvgcmt")
    public suspend fun predictiveScalingMaxCapacityBehavior(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.predictiveScalingMaxCapacityBehavior = mapped
    }

    /**
     * @param value Size of the capacity buffer to use when the forecast capacity is close to or exceeds the maximum capacity.
     */
    @JvmName("kilypdcdrrxvjwom")
    public suspend fun predictiveScalingMaxCapacityBuffer(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.predictiveScalingMaxCapacityBuffer = mapped
    }

    /**
     * @param value Predictive scaling mode. Valid values: `ForecastAndScale`, `ForecastOnly`.
     */
    @JvmName("oscmyiuyxaptjplk")
    public suspend fun predictiveScalingMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.predictiveScalingMode = mapped
    }

    /**
     * @param value ID of the resource. This string consists of the resource type and unique identifier.
     */
    @JvmName("excpsqaxynqbylmi")
    public suspend fun resourceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    /**
     * @param value Scalable dimension associated with the resource. Valid values: `autoscaling:autoScalingGroup:DesiredCapacity`, `dynamodb:index:ReadCapacityUnits`, `dynamodb:index:WriteCapacityUnits`, `dynamodb:table:ReadCapacityUnits`, `dynamodb:table:WriteCapacityUnits`, `ecs:service:DesiredCount`, `ec2:spot-fleet-request:TargetCapacity`, `rds:cluster:ReadReplicaCount`.
     */
    @JvmName("vbxeceeimdrmpuhr")
    public suspend fun scalableDimension(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scalableDimension = mapped
    }

    /**
     * @param value Controls whether a resource's externally created scaling policies are kept or replaced. Valid values: `KeepExternalPolicies`, `ReplaceExternalPolicies`. Defaults to `KeepExternalPolicies`.
     */
    @JvmName("qegsqmaohpxebqfd")
    public suspend fun scalingPolicyUpdateBehavior(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scalingPolicyUpdateBehavior = mapped
    }

    /**
     * @param value Amount of time, in seconds, to buffer the run time of scheduled scaling actions when scaling out.
     */
    @JvmName("txhgnhgbggcgittx")
    public suspend fun scheduledActionBufferTime(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheduledActionBufferTime = mapped
    }

    /**
     * @param value Namespace of the AWS service. Valid values: `autoscaling`, `dynamodb`, `ecs`, `ec2`, `rds`.
     */
    @JvmName("fedtlbtgxegglmjd")
    public suspend fun serviceNamespace(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceNamespace = mapped
    }

    /**
     * @param value Structure that defines new target tracking configurations. Each of these structures includes a specific scaling metric and a target value for the metric, along with various parameters to use with dynamic scaling.
     * More details can be found in the [AWS Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_TargetTrackingConfiguration.html).
     */
    @JvmName("apkqrlycemsjepxt")
    public suspend
    fun targetTrackingConfigurations(`value`: List<ScalingPlanScalingInstructionTargetTrackingConfigurationArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetTrackingConfigurations = mapped
    }

    /**
     * @param argument Structure that defines new target tracking configurations. Each of these structures includes a specific scaling metric and a target value for the metric, along with various parameters to use with dynamic scaling.
     * More details can be found in the [AWS Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_TargetTrackingConfiguration.html).
     */
    @JvmName("ppwxqduyakcyoren")
    public suspend
    fun targetTrackingConfigurations(argument: List<suspend ScalingPlanScalingInstructionTargetTrackingConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ScalingPlanScalingInstructionTargetTrackingConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.targetTrackingConfigurations = mapped
    }

    /**
     * @param argument Structure that defines new target tracking configurations. Each of these structures includes a specific scaling metric and a target value for the metric, along with various parameters to use with dynamic scaling.
     * More details can be found in the [AWS Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_TargetTrackingConfiguration.html).
     */
    @JvmName("citpmocoldcgsujx")
    public suspend fun targetTrackingConfigurations(
        vararg
        argument: suspend ScalingPlanScalingInstructionTargetTrackingConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ScalingPlanScalingInstructionTargetTrackingConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.targetTrackingConfigurations = mapped
    }

    /**
     * @param argument Structure that defines new target tracking configurations. Each of these structures includes a specific scaling metric and a target value for the metric, along with various parameters to use with dynamic scaling.
     * More details can be found in the [AWS Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_TargetTrackingConfiguration.html).
     */
    @JvmName("voraojkdwbtcyljq")
    public suspend
    fun targetTrackingConfigurations(argument: suspend ScalingPlanScalingInstructionTargetTrackingConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                ScalingPlanScalingInstructionTargetTrackingConfigurationArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.targetTrackingConfigurations = mapped
    }

    /**
     * @param values Structure that defines new target tracking configurations. Each of these structures includes a specific scaling metric and a target value for the metric, along with various parameters to use with dynamic scaling.
     * More details can be found in the [AWS Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_TargetTrackingConfiguration.html).
     */
    @JvmName("aarfcqsnrkitkhll")
    public suspend fun targetTrackingConfigurations(
        vararg
        values: ScalingPlanScalingInstructionTargetTrackingConfigurationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetTrackingConfigurations = mapped
    }

    internal fun build(): ScalingPlanScalingInstructionArgs = ScalingPlanScalingInstructionArgs(
        customizedLoadMetricSpecification = customizedLoadMetricSpecification,
        disableDynamicScaling = disableDynamicScaling,
        maxCapacity = maxCapacity ?: throw PulumiNullFieldException("maxCapacity"),
        minCapacity = minCapacity ?: throw PulumiNullFieldException("minCapacity"),
        predefinedLoadMetricSpecification = predefinedLoadMetricSpecification,
        predictiveScalingMaxCapacityBehavior = predictiveScalingMaxCapacityBehavior,
        predictiveScalingMaxCapacityBuffer = predictiveScalingMaxCapacityBuffer,
        predictiveScalingMode = predictiveScalingMode,
        resourceId = resourceId ?: throw PulumiNullFieldException("resourceId"),
        scalableDimension = scalableDimension ?: throw PulumiNullFieldException("scalableDimension"),
        scalingPolicyUpdateBehavior = scalingPolicyUpdateBehavior,
        scheduledActionBufferTime = scheduledActionBufferTime,
        serviceNamespace = serviceNamespace ?: throw PulumiNullFieldException("serviceNamespace"),
        targetTrackingConfigurations = targetTrackingConfigurations ?: throw
            PulumiNullFieldException("targetTrackingConfigurations"),
    )
}
