@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscalingplans.kotlin.inputs

import com.pulumi.aws.autoscalingplans.inputs.ScalingPlanScalingInstructionPredefinedLoadMetricSpecificationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property predefinedLoadMetricType Metric type. Valid values: `ALBTargetGroupRequestCount`, `ASGTotalCPUUtilization`, `ASGTotalNetworkIn`, `ASGTotalNetworkOut`.
 * @property resourceLabel Identifies the resource associated with the metric type.
 */
public data class ScalingPlanScalingInstructionPredefinedLoadMetricSpecificationArgs(
    public val predefinedLoadMetricType: Output<String>,
    public val resourceLabel: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.autoscalingplans.inputs.ScalingPlanScalingInstructionPredefinedLoadMetricSpecificationArgs> {
    override fun toJava():
        com.pulumi.aws.autoscalingplans.inputs.ScalingPlanScalingInstructionPredefinedLoadMetricSpecificationArgs =
        com.pulumi.aws.autoscalingplans.inputs.ScalingPlanScalingInstructionPredefinedLoadMetricSpecificationArgs.builder()
            .predefinedLoadMetricType(predefinedLoadMetricType.applyValue({ args0 -> args0 }))
            .resourceLabel(resourceLabel?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScalingPlanScalingInstructionPredefinedLoadMetricSpecificationArgs].
 */
@PulumiTagMarker
public class ScalingPlanScalingInstructionPredefinedLoadMetricSpecificationArgsBuilder internal
constructor() {
    private var predefinedLoadMetricType: Output<String>? = null

    private var resourceLabel: Output<String>? = null

    /**
     * @param value Metric type. Valid values: `ALBTargetGroupRequestCount`, `ASGTotalCPUUtilization`, `ASGTotalNetworkIn`, `ASGTotalNetworkOut`.
     */
    @JvmName("fvhkgydspbdttand")
    public suspend fun predefinedLoadMetricType(`value`: Output<String>) {
        this.predefinedLoadMetricType = value
    }

    /**
     * @param value Identifies the resource associated with the metric type.
     */
    @JvmName("uxetlkmemthutluw")
    public suspend fun resourceLabel(`value`: Output<String>) {
        this.resourceLabel = value
    }

    /**
     * @param value Metric type. Valid values: `ALBTargetGroupRequestCount`, `ASGTotalCPUUtilization`, `ASGTotalNetworkIn`, `ASGTotalNetworkOut`.
     */
    @JvmName("qhvobbxfdxspmmoo")
    public suspend fun predefinedLoadMetricType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.predefinedLoadMetricType = mapped
    }

    /**
     * @param value Identifies the resource associated with the metric type.
     */
    @JvmName("oiriuirxqkfwqltc")
    public suspend fun resourceLabel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceLabel = mapped
    }

    internal fun build(): ScalingPlanScalingInstructionPredefinedLoadMetricSpecificationArgs =
        ScalingPlanScalingInstructionPredefinedLoadMetricSpecificationArgs(
            predefinedLoadMetricType = predefinedLoadMetricType ?: throw
                PulumiNullFieldException("predefinedLoadMetricType"),
            resourceLabel = resourceLabel,
        )
}
