@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscalingplans.kotlin.inputs

import com.pulumi.aws.autoscalingplans.inputs.ScalingPlanScalingInstructionTargetTrackingConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property customizedScalingMetricSpecification Customized metric. You can specify either `customized_scaling_metric_specification` or `predefined_scaling_metric_specification`.
 * More details can be found in the [AWS Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_CustomizedScalingMetricSpecification.html).
 * @property disableScaleIn Boolean indicating whether scale in by the target tracking scaling policy is disabled. Defaults to `false`.
 * @property estimatedInstanceWarmup Estimated time, in seconds, until a newly launched instance can contribute to the CloudWatch metrics.
 * This value is used only if the resource is an Auto Scaling group.
 * @property predefinedScalingMetricSpecification Predefined metric. You can specify either `predefined_scaling_metric_specification` or `customized_scaling_metric_specification`.
 * More details can be found in the [AWS Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_PredefinedScalingMetricSpecification.html).
 * @property scaleInCooldown Amount of time, in seconds, after a scale in activity completes before another scale in activity can start.
 * This value is not used if the scalable resource is an Auto Scaling group.
 * @property scaleOutCooldown Amount of time, in seconds, after a scale-out activity completes before another scale-out activity can start.
 * This value is not used if the scalable resource is an Auto Scaling group.
 * @property targetValue Target value for the metric.
 */
public data class ScalingPlanScalingInstructionTargetTrackingConfigurationArgs(
    public val customizedScalingMetricSpecification:
    Output<ScalingPlanScalingInstructionTargetTrackingConfigurationCustomizedScalingMetricSpecificationArgs>? =
        null,
    public val disableScaleIn: Output<Boolean>? = null,
    public val estimatedInstanceWarmup: Output<Int>? = null,
    public val predefinedScalingMetricSpecification:
    Output<ScalingPlanScalingInstructionTargetTrackingConfigurationPredefinedScalingMetricSpecificationArgs>? =
        null,
    public val scaleInCooldown: Output<Int>? = null,
    public val scaleOutCooldown: Output<Int>? = null,
    public val targetValue: Output<Double>,
) :
    ConvertibleToJava<com.pulumi.aws.autoscalingplans.inputs.ScalingPlanScalingInstructionTargetTrackingConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.autoscalingplans.inputs.ScalingPlanScalingInstructionTargetTrackingConfigurationArgs =
        com.pulumi.aws.autoscalingplans.inputs.ScalingPlanScalingInstructionTargetTrackingConfigurationArgs.builder()
            .customizedScalingMetricSpecification(
                customizedScalingMetricSpecification?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .disableScaleIn(disableScaleIn?.applyValue({ args0 -> args0 }))
            .estimatedInstanceWarmup(estimatedInstanceWarmup?.applyValue({ args0 -> args0 }))
            .predefinedScalingMetricSpecification(
                predefinedScalingMetricSpecification?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .scaleInCooldown(scaleInCooldown?.applyValue({ args0 -> args0 }))
            .scaleOutCooldown(scaleOutCooldown?.applyValue({ args0 -> args0 }))
            .targetValue(targetValue.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScalingPlanScalingInstructionTargetTrackingConfigurationArgs].
 */
@PulumiTagMarker
public class ScalingPlanScalingInstructionTargetTrackingConfigurationArgsBuilder internal
constructor() {
    private var customizedScalingMetricSpecification:
        Output<ScalingPlanScalingInstructionTargetTrackingConfigurationCustomizedScalingMetricSpecificationArgs>? =
        null

    private var disableScaleIn: Output<Boolean>? = null

    private var estimatedInstanceWarmup: Output<Int>? = null

    private var predefinedScalingMetricSpecification:
        Output<ScalingPlanScalingInstructionTargetTrackingConfigurationPredefinedScalingMetricSpecificationArgs>? =
        null

    private var scaleInCooldown: Output<Int>? = null

    private var scaleOutCooldown: Output<Int>? = null

    private var targetValue: Output<Double>? = null

    /**
     * @param value Customized metric. You can specify either `customized_scaling_metric_specification` or `predefined_scaling_metric_specification`.
     * More details can be found in the [AWS Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_CustomizedScalingMetricSpecification.html).
     */
    @JvmName("snecmqkrjxnxsqbb")
    public suspend
    fun customizedScalingMetricSpecification(`value`: Output<ScalingPlanScalingInstructionTargetTrackingConfigurationCustomizedScalingMetricSpecificationArgs>) {
        this.customizedScalingMetricSpecification = value
    }

    /**
     * @param value Boolean indicating whether scale in by the target tracking scaling policy is disabled. Defaults to `false`.
     */
    @JvmName("mkavaxueptlxexey")
    public suspend fun disableScaleIn(`value`: Output<Boolean>) {
        this.disableScaleIn = value
    }

    /**
     * @param value Estimated time, in seconds, until a newly launched instance can contribute to the CloudWatch metrics.
     * This value is used only if the resource is an Auto Scaling group.
     */
    @JvmName("xipntnhkbgebpoxd")
    public suspend fun estimatedInstanceWarmup(`value`: Output<Int>) {
        this.estimatedInstanceWarmup = value
    }

    /**
     * @param value Predefined metric. You can specify either `predefined_scaling_metric_specification` or `customized_scaling_metric_specification`.
     * More details can be found in the [AWS Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_PredefinedScalingMetricSpecification.html).
     */
    @JvmName("aspsmhawsoffwsuj")
    public suspend
    fun predefinedScalingMetricSpecification(`value`: Output<ScalingPlanScalingInstructionTargetTrackingConfigurationPredefinedScalingMetricSpecificationArgs>) {
        this.predefinedScalingMetricSpecification = value
    }

    /**
     * @param value Amount of time, in seconds, after a scale in activity completes before another scale in activity can start.
     * This value is not used if the scalable resource is an Auto Scaling group.
     */
    @JvmName("uxheoxoqpxgxqpdf")
    public suspend fun scaleInCooldown(`value`: Output<Int>) {
        this.scaleInCooldown = value
    }

    /**
     * @param value Amount of time, in seconds, after a scale-out activity completes before another scale-out activity can start.
     * This value is not used if the scalable resource is an Auto Scaling group.
     */
    @JvmName("tlpmkrtvpdbwarls")
    public suspend fun scaleOutCooldown(`value`: Output<Int>) {
        this.scaleOutCooldown = value
    }

    /**
     * @param value Target value for the metric.
     */
    @JvmName("uwxrxlrhpjgqfddk")
    public suspend fun targetValue(`value`: Output<Double>) {
        this.targetValue = value
    }

    /**
     * @param value Customized metric. You can specify either `customized_scaling_metric_specification` or `predefined_scaling_metric_specification`.
     * More details can be found in the [AWS Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_CustomizedScalingMetricSpecification.html).
     */
    @JvmName("ucyxgbsdpvaihoof")
    public suspend
    fun customizedScalingMetricSpecification(`value`: ScalingPlanScalingInstructionTargetTrackingConfigurationCustomizedScalingMetricSpecificationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customizedScalingMetricSpecification = mapped
    }

    /**
     * @param argument Customized metric. You can specify either `customized_scaling_metric_specification` or `predefined_scaling_metric_specification`.
     * More details can be found in the [AWS Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_CustomizedScalingMetricSpecification.html).
     */
    @JvmName("kftqsvortweoxius")
    public suspend
    fun customizedScalingMetricSpecification(argument: suspend ScalingPlanScalingInstructionTargetTrackingConfigurationCustomizedScalingMetricSpecificationArgsBuilder.() -> Unit) {
        val toBeMapped =
            ScalingPlanScalingInstructionTargetTrackingConfigurationCustomizedScalingMetricSpecificationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.customizedScalingMetricSpecification = mapped
    }

    /**
     * @param value Boolean indicating whether scale in by the target tracking scaling policy is disabled. Defaults to `false`.
     */
    @JvmName("vxgtndbtdxtpdrqx")
    public suspend fun disableScaleIn(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableScaleIn = mapped
    }

    /**
     * @param value Estimated time, in seconds, until a newly launched instance can contribute to the CloudWatch metrics.
     * This value is used only if the resource is an Auto Scaling group.
     */
    @JvmName("wcbaxcyxgbmdpsuj")
    public suspend fun estimatedInstanceWarmup(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.estimatedInstanceWarmup = mapped
    }

    /**
     * @param value Predefined metric. You can specify either `predefined_scaling_metric_specification` or `customized_scaling_metric_specification`.
     * More details can be found in the [AWS Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_PredefinedScalingMetricSpecification.html).
     */
    @JvmName("iwgabahguhupeqrn")
    public suspend
    fun predefinedScalingMetricSpecification(`value`: ScalingPlanScalingInstructionTargetTrackingConfigurationPredefinedScalingMetricSpecificationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.predefinedScalingMetricSpecification = mapped
    }

    /**
     * @param argument Predefined metric. You can specify either `predefined_scaling_metric_specification` or `customized_scaling_metric_specification`.
     * More details can be found in the [AWS Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_PredefinedScalingMetricSpecification.html).
     */
    @JvmName("clqnmtkevwyhhlsw")
    public suspend
    fun predefinedScalingMetricSpecification(argument: suspend ScalingPlanScalingInstructionTargetTrackingConfigurationPredefinedScalingMetricSpecificationArgsBuilder.() -> Unit) {
        val toBeMapped =
            ScalingPlanScalingInstructionTargetTrackingConfigurationPredefinedScalingMetricSpecificationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.predefinedScalingMetricSpecification = mapped
    }

    /**
     * @param value Amount of time, in seconds, after a scale in activity completes before another scale in activity can start.
     * This value is not used if the scalable resource is an Auto Scaling group.
     */
    @JvmName("xhfcjguvotrfillj")
    public suspend fun scaleInCooldown(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scaleInCooldown = mapped
    }

    /**
     * @param value Amount of time, in seconds, after a scale-out activity completes before another scale-out activity can start.
     * This value is not used if the scalable resource is an Auto Scaling group.
     */
    @JvmName("ncrgyoquilockrwe")
    public suspend fun scaleOutCooldown(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scaleOutCooldown = mapped
    }

    /**
     * @param value Target value for the metric.
     */
    @JvmName("nhirawifvbmhhnxr")
    public suspend fun targetValue(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetValue = mapped
    }

    internal fun build(): ScalingPlanScalingInstructionTargetTrackingConfigurationArgs =
        ScalingPlanScalingInstructionTargetTrackingConfigurationArgs(
            customizedScalingMetricSpecification = customizedScalingMetricSpecification,
            disableScaleIn = disableScaleIn,
            estimatedInstanceWarmup = estimatedInstanceWarmup,
            predefinedScalingMetricSpecification = predefinedScalingMetricSpecification,
            scaleInCooldown = scaleInCooldown,
            scaleOutCooldown = scaleOutCooldown,
            targetValue = targetValue ?: throw PulumiNullFieldException("targetValue"),
        )
}
