@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscalingplans.kotlin.inputs

import com.pulumi.aws.autoscalingplans.inputs.ScalingPlanScalingInstructionTargetTrackingConfigurationPredefinedScalingMetricSpecificationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property predefinedScalingMetricType Metric type. Valid values: `ALBRequestCountPerTarget`, `ASGAverageCPUUtilization`, `ASGAverageNetworkIn`, `ASGAverageNetworkOut`, `DynamoDBReadCapacityUtilization`, `DynamoDBWriteCapacityUtilization`, `ECSServiceAverageCPUUtilization`, `ECSServiceAverageMemoryUtilization`, `EC2SpotFleetRequestAverageCPUUtilization`, `EC2SpotFleetRequestAverageNetworkIn`, `EC2SpotFleetRequestAverageNetworkOut`, `RDSReaderAverageCPUUtilization`, `RDSReaderAverageDatabaseConnections`.
 * @property resourceLabel Identifies the resource associated with the metric type.
 */
public data class
ScalingPlanScalingInstructionTargetTrackingConfigurationPredefinedScalingMetricSpecificationArgs(
    public val predefinedScalingMetricType: Output<String>,
    public val resourceLabel: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.autoscalingplans.inputs.ScalingPlanScalingInstructionTargetTrackingConfigurationPredefinedScalingMetricSpecificationArgs> {
    override fun toJava():
        com.pulumi.aws.autoscalingplans.inputs.ScalingPlanScalingInstructionTargetTrackingConfigurationPredefinedScalingMetricSpecificationArgs =
        com.pulumi.aws.autoscalingplans.inputs.ScalingPlanScalingInstructionTargetTrackingConfigurationPredefinedScalingMetricSpecificationArgs.builder()
            .predefinedScalingMetricType(predefinedScalingMetricType.applyValue({ args0 -> args0 }))
            .resourceLabel(resourceLabel?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScalingPlanScalingInstructionTargetTrackingConfigurationPredefinedScalingMetricSpecificationArgs].
 */
@PulumiTagMarker
public class
ScalingPlanScalingInstructionTargetTrackingConfigurationPredefinedScalingMetricSpecificationArgsBuilder
internal constructor() {
    private var predefinedScalingMetricType: Output<String>? = null

    private var resourceLabel: Output<String>? = null

    /**
     * @param value Metric type. Valid values: `ALBRequestCountPerTarget`, `ASGAverageCPUUtilization`, `ASGAverageNetworkIn`, `ASGAverageNetworkOut`, `DynamoDBReadCapacityUtilization`, `DynamoDBWriteCapacityUtilization`, `ECSServiceAverageCPUUtilization`, `ECSServiceAverageMemoryUtilization`, `EC2SpotFleetRequestAverageCPUUtilization`, `EC2SpotFleetRequestAverageNetworkIn`, `EC2SpotFleetRequestAverageNetworkOut`, `RDSReaderAverageCPUUtilization`, `RDSReaderAverageDatabaseConnections`.
     */
    @JvmName("ewioubtbwyonbpwb")
    public suspend fun predefinedScalingMetricType(`value`: Output<String>) {
        this.predefinedScalingMetricType = value
    }

    /**
     * @param value Identifies the resource associated with the metric type.
     */
    @JvmName("xfpowjyrrdbllmra")
    public suspend fun resourceLabel(`value`: Output<String>) {
        this.resourceLabel = value
    }

    /**
     * @param value Metric type. Valid values: `ALBRequestCountPerTarget`, `ASGAverageCPUUtilization`, `ASGAverageNetworkIn`, `ASGAverageNetworkOut`, `DynamoDBReadCapacityUtilization`, `DynamoDBWriteCapacityUtilization`, `ECSServiceAverageCPUUtilization`, `ECSServiceAverageMemoryUtilization`, `EC2SpotFleetRequestAverageCPUUtilization`, `EC2SpotFleetRequestAverageNetworkIn`, `EC2SpotFleetRequestAverageNetworkOut`, `RDSReaderAverageCPUUtilization`, `RDSReaderAverageDatabaseConnections`.
     */
    @JvmName("cgpeesunrvwcuxkw")
    public suspend fun predefinedScalingMetricType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.predefinedScalingMetricType = mapped
    }

    /**
     * @param value Identifies the resource associated with the metric type.
     */
    @JvmName("jmvrscifyqrsdrwn")
    public suspend fun resourceLabel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceLabel = mapped
    }

    internal fun build():
        ScalingPlanScalingInstructionTargetTrackingConfigurationPredefinedScalingMetricSpecificationArgs =
        ScalingPlanScalingInstructionTargetTrackingConfigurationPredefinedScalingMetricSpecificationArgs(
            predefinedScalingMetricType = predefinedScalingMetricType ?: throw
                PulumiNullFieldException("predefinedScalingMetricType"),
            resourceLabel = resourceLabel,
        )
}
