@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscalingplans.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property cloudformationStackArn ARN of a AWS CloudFormation stack.
 * @property tagFilters Set of tags.
 */
public data class ScalingPlanApplicationSource(
    public val cloudformationStackArn: String? = null,
    public val tagFilters: List<ScalingPlanApplicationSourceTagFilter>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.autoscalingplans.outputs.ScalingPlanApplicationSource):
            ScalingPlanApplicationSource = ScalingPlanApplicationSource(
            cloudformationStackArn = javaType.cloudformationStackArn().map({ args0 -> args0 }).orElse(null),
            tagFilters = javaType.tagFilters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.autoscalingplans.kotlin.outputs.ScalingPlanApplicationSourceTagFilter.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
