@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscalingplans.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property dimensions Dimensions of the metric.
 * @property metricName Name of the metric.
 * @property namespace Namespace of the metric.
 * @property statistic Statistic of the metric. Valid values: `Average`, `Maximum`, `Minimum`, `SampleCount`, `Sum`.
 * @property unit Unit of the metric.
 */
public data class
ScalingPlanScalingInstructionTargetTrackingConfigurationCustomizedScalingMetricSpecification(
    public val dimensions: Map<String, String>? = null,
    public val metricName: String,
    public val namespace: String,
    public val statistic: String,
    public val unit: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.autoscalingplans.outputs.ScalingPlanScalingInstructionTargetTrackingConfigurationCustomizedScalingMetricSpecification):
            ScalingPlanScalingInstructionTargetTrackingConfigurationCustomizedScalingMetricSpecification =
            ScalingPlanScalingInstructionTargetTrackingConfigurationCustomizedScalingMetricSpecification(
                dimensions = javaType.dimensions().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                metricName = javaType.metricName(),
                namespace = javaType.namespace(),
                statistic = javaType.statistic(),
                unit = javaType.unit().map({ args0 -> args0 }).orElse(null),
            )
    }
}
