@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscalingplans.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property predefinedScalingMetricType Metric type. Valid values: `ALBRequestCountPerTarget`, `ASGAverageCPUUtilization`, `ASGAverageNetworkIn`, `ASGAverageNetworkOut`, `DynamoDBReadCapacityUtilization`, `DynamoDBWriteCapacityUtilization`, `ECSServiceAverageCPUUtilization`, `ECSServiceAverageMemoryUtilization`, `EC2SpotFleetRequestAverageCPUUtilization`, `EC2SpotFleetRequestAverageNetworkIn`, `EC2SpotFleetRequestAverageNetworkOut`, `RDSReaderAverageCPUUtilization`, `RDSReaderAverageDatabaseConnections`.
 * @property resourceLabel Identifies the resource associated with the metric type.
 */
public data class
ScalingPlanScalingInstructionTargetTrackingConfigurationPredefinedScalingMetricSpecification(
    public val predefinedScalingMetricType: String,
    public val resourceLabel: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.autoscalingplans.outputs.ScalingPlanScalingInstructionTargetTrackingConfigurationPredefinedScalingMetricSpecification):
            ScalingPlanScalingInstructionTargetTrackingConfigurationPredefinedScalingMetricSpecification =
            ScalingPlanScalingInstructionTargetTrackingConfigurationPredefinedScalingMetricSpecification(
                predefinedScalingMetricType = javaType.predefinedScalingMetricType(),
                resourceLabel = javaType.resourceLabel().map({ args0 -> args0 }).orElse(null),
            )
    }
}
