@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.backup.kotlin

import com.pulumi.aws.backup.kotlin.outputs.FrameworkControl
import com.pulumi.aws.backup.kotlin.outputs.FrameworkControl.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Framework].
 */
@PulumiTagMarker
public class FrameworkResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FrameworkArgs = FrameworkArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FrameworkArgsBuilder.() -> Unit) {
        val builder = FrameworkArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Framework {
        val builtJavaResource = com.pulumi.aws.backup.Framework(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Framework(builtJavaResource)
    }
}

/**
 * Provides an AWS Backup Framework resource.
 * > **Note:** For the Deployment Status of the Framework to be successful, please turn on resource tracking to enable AWS Config recording to track configuration changes of your backup resources. This can be done from the AWS Console.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.backup.Framework;
 * import com.pulumi.aws.backup.FrameworkArgs;
 * import com.pulumi.aws.backup.inputs.FrameworkControlArgs;
 * import com.pulumi.aws.backup.inputs.FrameworkControlScopeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Framework("example", FrameworkArgs.builder()
 *             .controls(
 *                 FrameworkControlArgs.builder()
 *                     .inputParameters(FrameworkControlInputParameterArgs.builder()
 *                         .name("requiredRetentionDays")
 *                         .value("35")
 *                         .build())
 *                     .name("BACKUP_RECOVERY_POINT_MINIMUM_RETENTION_CHECK")
 *                     .build(),
 *                 FrameworkControlArgs.builder()
 *                     .inputParameters(
 *                         FrameworkControlInputParameterArgs.builder()
 *                             .name("requiredFrequencyUnit")
 *                             .value("hours")
 *                             .build(),
 *                         FrameworkControlInputParameterArgs.builder()
 *                             .name("requiredRetentionDays")
 *                             .value("35")
 *                             .build(),
 *                         FrameworkControlInputParameterArgs.builder()
 *                             .name("requiredFrequencyValue")
 *                             .value("1")
 *                             .build())
 *                     .name("BACKUP_PLAN_MIN_FREQUENCY_AND_MIN_RETENTION_CHECK")
 *                     .build(),
 *                 FrameworkControlArgs.builder()
 *                     .name("BACKUP_RECOVERY_POINT_ENCRYPTED")
 *                     .build(),
 *                 FrameworkControlArgs.builder()
 *                     .name("BACKUP_RESOURCES_PROTECTED_BY_BACKUP_PLAN")
 *                     .scope(FrameworkControlScopeArgs.builder()
 *                         .complianceResourceTypes("EBS")
 *                         .build())
 *                     .build(),
 *                 FrameworkControlArgs.builder()
 *                     .name("BACKUP_RECOVERY_POINT_MANUAL_DELETION_DISABLED")
 *                     .build(),
 *                 FrameworkControlArgs.builder()
 *                     .inputParameters(
 *                         FrameworkControlInputParameterArgs.builder()
 *                             .name("maxRetentionDays")
 *                             .value("100")
 *                             .build(),
 *                         FrameworkControlInputParameterArgs.builder()
 *                             .name("minRetentionDays")
 *                             .value("1")
 *                             .build())
 *                     .name("BACKUP_RESOURCES_PROTECTED_BY_BACKUP_VAULT_LOCK")
 *                     .scope(FrameworkControlScopeArgs.builder()
 *                         .complianceResourceTypes("EBS")
 *                         .build())
 *                     .build(),
 *                 FrameworkControlArgs.builder()
 *                     .inputParameters(
 *                         FrameworkControlInputParameterArgs.builder()
 *                             .name("recoveryPointAgeUnit")
 *                             .value("days")
 *                             .build(),
 *                         FrameworkControlInputParameterArgs.builder()
 *                             .name("recoveryPointAgeValue")
 *                             .value("1")
 *                             .build())
 *                     .name("BACKUP_LAST_RECOVERY_POINT_CREATED")
 *                     .scope(FrameworkControlScopeArgs.builder()
 *                         .complianceResourceTypes("EBS")
 *                         .build())
 *                     .build())
 *             .description("this is an example framework")
 *             .tags(Map.of("Name", "Example Framework"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Backup Framework using the `id` which corresponds to the name of the Backup Framework. For example:
 * ```sh
 *  $ pulumi import aws:backup/framework:Framework test <id>
 * ```
 *
 */
public class Framework internal constructor(
    override val javaResource: com.pulumi.aws.backup.Framework,
) : KotlinCustomResource(javaResource, FrameworkMapper) {
    /**
     * The ARN of the backup framework.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * One or more control blocks that make up the framework. Each control in the list has a name, input parameters, and scope. Detailed below.
     */
    public val controls: Output<List<FrameworkControl>>
        get() = javaResource.controls().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    /**
     * The date and time that a framework is created, in Unix format and Coordinated Universal Time (UTC).
     */
    public val creationTime: Output<String>
        get() = javaResource.creationTime().applyValue({ args0 -> args0 })

    /**
     * The deployment status of a framework. The statuses are: `CREATE_IN_PROGRESS` | `UPDATE_IN_PROGRESS` | `DELETE_IN_PROGRESS` | `COMPLETED` | `FAILED`.
     */
    public val deploymentStatus: Output<String>
        get() = javaResource.deploymentStatus().applyValue({ args0 -> args0 })

    /**
     * The description of the framework with a maximum of 1,024 characters
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The unique name of the framework. The name must be between 1 and 256 characters, starting with a letter, and consisting of letters, numbers, and underscores.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A framework consists of one or more controls. Each control governs a resource, such as backup plans, backup selections, backup vaults, or recovery points. You can also turn AWS Config recording on or off for each resource. For more information refer to the [AWS documentation for Framework Status](https://docs.aws.amazon.com/aws-backup/latest/devguide/API_DescribeFramework.html#Backup-DescribeFramework-response-FrameworkStatus)
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Metadata that you can assign to help organize the frameworks you create. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object FrameworkMapper : ResourceMapper<Framework> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.backup.Framework::class == javaResource::class

    override fun map(javaResource: Resource): Framework = Framework(
        javaResource as
            com.pulumi.aws.backup.Framework,
    )
}

/**
 * @see [Framework].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Framework].
 */
public suspend fun framework(name: String, block: suspend FrameworkResourceBuilder.() -> Unit):
    Framework {
    val builder = FrameworkResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Framework].
 * @param name The _unique_ name of the resulting resource.
 */
public fun framework(name: String): Framework {
    val builder = FrameworkResourceBuilder()
    builder.name(name)
    return builder.build()
}
