@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.backup.kotlin

import com.pulumi.aws.backup.FrameworkArgs.builder
import com.pulumi.aws.backup.kotlin.inputs.FrameworkControlArgs
import com.pulumi.aws.backup.kotlin.inputs.FrameworkControlArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an AWS Backup Framework resource.
 * > **Note:** For the Deployment Status of the Framework to be successful, please turn on resource tracking to enable AWS Config recording to track configuration changes of your backup resources. This can be done from the AWS Console.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.backup.Framework;
 * import com.pulumi.aws.backup.FrameworkArgs;
 * import com.pulumi.aws.backup.inputs.FrameworkControlArgs;
 * import com.pulumi.aws.backup.inputs.FrameworkControlScopeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Framework("example", FrameworkArgs.builder()
 *             .controls(
 *                 FrameworkControlArgs.builder()
 *                     .inputParameters(FrameworkControlInputParameterArgs.builder()
 *                         .name("requiredRetentionDays")
 *                         .value("35")
 *                         .build())
 *                     .name("BACKUP_RECOVERY_POINT_MINIMUM_RETENTION_CHECK")
 *                     .build(),
 *                 FrameworkControlArgs.builder()
 *                     .inputParameters(
 *                         FrameworkControlInputParameterArgs.builder()
 *                             .name("requiredFrequencyUnit")
 *                             .value("hours")
 *                             .build(),
 *                         FrameworkControlInputParameterArgs.builder()
 *                             .name("requiredRetentionDays")
 *                             .value("35")
 *                             .build(),
 *                         FrameworkControlInputParameterArgs.builder()
 *                             .name("requiredFrequencyValue")
 *                             .value("1")
 *                             .build())
 *                     .name("BACKUP_PLAN_MIN_FREQUENCY_AND_MIN_RETENTION_CHECK")
 *                     .build(),
 *                 FrameworkControlArgs.builder()
 *                     .name("BACKUP_RECOVERY_POINT_ENCRYPTED")
 *                     .build(),
 *                 FrameworkControlArgs.builder()
 *                     .name("BACKUP_RESOURCES_PROTECTED_BY_BACKUP_PLAN")
 *                     .scope(FrameworkControlScopeArgs.builder()
 *                         .complianceResourceTypes("EBS")
 *                         .build())
 *                     .build(),
 *                 FrameworkControlArgs.builder()
 *                     .name("BACKUP_RECOVERY_POINT_MANUAL_DELETION_DISABLED")
 *                     .build(),
 *                 FrameworkControlArgs.builder()
 *                     .inputParameters(
 *                         FrameworkControlInputParameterArgs.builder()
 *                             .name("maxRetentionDays")
 *                             .value("100")
 *                             .build(),
 *                         FrameworkControlInputParameterArgs.builder()
 *                             .name("minRetentionDays")
 *                             .value("1")
 *                             .build())
 *                     .name("BACKUP_RESOURCES_PROTECTED_BY_BACKUP_VAULT_LOCK")
 *                     .scope(FrameworkControlScopeArgs.builder()
 *                         .complianceResourceTypes("EBS")
 *                         .build())
 *                     .build(),
 *                 FrameworkControlArgs.builder()
 *                     .inputParameters(
 *                         FrameworkControlInputParameterArgs.builder()
 *                             .name("recoveryPointAgeUnit")
 *                             .value("days")
 *                             .build(),
 *                         FrameworkControlInputParameterArgs.builder()
 *                             .name("recoveryPointAgeValue")
 *                             .value("1")
 *                             .build())
 *                     .name("BACKUP_LAST_RECOVERY_POINT_CREATED")
 *                     .scope(FrameworkControlScopeArgs.builder()
 *                         .complianceResourceTypes("EBS")
 *                         .build())
 *                     .build())
 *             .description("this is an example framework")
 *             .tags(Map.of("Name", "Example Framework"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Backup Framework using the `id` which corresponds to the name of the Backup Framework. For example:
 * ```sh
 *  $ pulumi import aws:backup/framework:Framework test <id>
 * ```
 * @property controls One or more control blocks that make up the framework. Each control in the list has a name, input parameters, and scope. Detailed below.
 * @property description The description of the framework with a maximum of 1,024 characters
 * @property name The unique name of the framework. The name must be between 1 and 256 characters, starting with a letter, and consisting of letters, numbers, and underscores.
 * @property tags Metadata that you can assign to help organize the frameworks you create. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class FrameworkArgs(
    public val controls: Output<List<FrameworkControlArgs>>? = null,
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.backup.FrameworkArgs> {
    override fun toJava(): com.pulumi.aws.backup.FrameworkArgs =
        com.pulumi.aws.backup.FrameworkArgs.builder()
            .controls(
                controls?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [FrameworkArgs].
 */
@PulumiTagMarker
public class FrameworkArgsBuilder internal constructor() {
    private var controls: Output<List<FrameworkControlArgs>>? = null

    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value One or more control blocks that make up the framework. Each control in the list has a name, input parameters, and scope. Detailed below.
     */
    @JvmName("aefujinrdpbrllgs")
    public suspend fun controls(`value`: Output<List<FrameworkControlArgs>>) {
        this.controls = value
    }

    @JvmName("icoeocdhmfnyhqwl")
    public suspend fun controls(vararg values: Output<FrameworkControlArgs>) {
        this.controls = Output.all(values.asList())
    }

    /**
     * @param values One or more control blocks that make up the framework. Each control in the list has a name, input parameters, and scope. Detailed below.
     */
    @JvmName("svmyusvfcgorcxxy")
    public suspend fun controls(values: List<Output<FrameworkControlArgs>>) {
        this.controls = Output.all(values)
    }

    /**
     * @param value The description of the framework with a maximum of 1,024 characters
     */
    @JvmName("tuucenycuvpcdoql")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The unique name of the framework. The name must be between 1 and 256 characters, starting with a letter, and consisting of letters, numbers, and underscores.
     */
    @JvmName("jbvtmcamyeqlfxvy")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Metadata that you can assign to help organize the frameworks you create. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("fhvgmcwsyjbsmhsc")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value One or more control blocks that make up the framework. Each control in the list has a name, input parameters, and scope. Detailed below.
     */
    @JvmName("ahcenqxkfmlfbgof")
    public suspend fun controls(`value`: List<FrameworkControlArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.controls = mapped
    }

    /**
     * @param argument One or more control blocks that make up the framework. Each control in the list has a name, input parameters, and scope. Detailed below.
     */
    @JvmName("umlypfktimmlxxjx")
    public suspend fun controls(argument: List<suspend FrameworkControlArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FrameworkControlArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.controls = mapped
    }

    /**
     * @param argument One or more control blocks that make up the framework. Each control in the list has a name, input parameters, and scope. Detailed below.
     */
    @JvmName("bnhwntoestsrlrvn")
    public suspend fun controls(vararg argument: suspend FrameworkControlArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            FrameworkControlArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.controls = mapped
    }

    /**
     * @param argument One or more control blocks that make up the framework. Each control in the list has a name, input parameters, and scope. Detailed below.
     */
    @JvmName("goeeqafxxalgkppu")
    public suspend fun controls(argument: suspend FrameworkControlArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(FrameworkControlArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.controls = mapped
    }

    /**
     * @param values One or more control blocks that make up the framework. Each control in the list has a name, input parameters, and scope. Detailed below.
     */
    @JvmName("rscucgtitfkffuwr")
    public suspend fun controls(vararg values: FrameworkControlArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.controls = mapped
    }

    /**
     * @param value The description of the framework with a maximum of 1,024 characters
     */
    @JvmName("grikgpgumbkclmvv")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The unique name of the framework. The name must be between 1 and 256 characters, starting with a letter, and consisting of letters, numbers, and underscores.
     */
    @JvmName("vleedsychtinhjsd")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Metadata that you can assign to help organize the frameworks you create. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("bylslxkxctcfhwxf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Metadata that you can assign to help organize the frameworks you create. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("lsmabtoslrbfeanp")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): FrameworkArgs = FrameworkArgs(
        controls = controls,
        description = description,
        name = name,
        tags = tags,
    )
}
