@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.backup.kotlin

import com.pulumi.aws.backup.GlobalSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an AWS Backup Global Settings resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.backup.GlobalSettings;
 * import com.pulumi.aws.backup.GlobalSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new GlobalSettings("test", GlobalSettingsArgs.builder()
 *             .globalSettings(Map.of("isCrossAccountBackupEnabled", "true"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Backup Global Settings using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:backup/globalSettings:GlobalSettings example 123456789012
 * ```
 * @property globalSettings A list of resources along with the opt-in preferences for the account.
 */
public data class GlobalSettingsArgs(
    public val globalSettings: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.backup.GlobalSettingsArgs> {
    override fun toJava(): com.pulumi.aws.backup.GlobalSettingsArgs =
        com.pulumi.aws.backup.GlobalSettingsArgs.builder()
            .globalSettings(
                globalSettings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [GlobalSettingsArgs].
 */
@PulumiTagMarker
public class GlobalSettingsArgsBuilder internal constructor() {
    private var globalSettings: Output<Map<String, String>>? = null

    /**
     * @param value A list of resources along with the opt-in preferences for the account.
     */
    @JvmName("cdwaetmlclowfnwl")
    public suspend fun globalSettings(`value`: Output<Map<String, String>>) {
        this.globalSettings = value
    }

    /**
     * @param value A list of resources along with the opt-in preferences for the account.
     */
    @JvmName("fyjbespkjlrqkvhw")
    public suspend fun globalSettings(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.globalSettings = mapped
    }

    /**
     * @param values A list of resources along with the opt-in preferences for the account.
     */
    @JvmName("mwwbuhhajtrywohf")
    public fun globalSettings(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.globalSettings = mapped
    }

    internal fun build(): GlobalSettingsArgs = GlobalSettingsArgs(
        globalSettings = globalSettings,
    )
}
